proc (z) = cmul (x, y)  
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cadd cdiv csub
; -----------------------------------------------------------------------
; Macro        cmul
; -----------------------------------------------------------------------
; Description  Complex multiplication
; -----------------------------------------------------------------------
; Usage        z = cmul (x, y)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  y 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (0, 1)
;	             y = complex (1, 0)
; 	           cmul (x, y)
; -----------------------------------------------------------------------
; Result       Contents of z.re 
;		           [1,]        0 
;              Contents of z.im
; 		         [1,]        1 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cmul : No real part in x found")
  error (comp(x, "im")<1, "cmul : No imaginary part in x found")
  error (comp(y, "re")<1, "cmul : No real part in y found")
  error (comp(y, "im")<1, "cmul : No imaginary part in y found")  
  re = x.re.*y.re - x.im.*y.im  
  im = x.re.*y.im + x.im.*y.re
  z  = list(re,im)  
endp  



