proc(b)=coeffss(r,icovu,zz,ord,di,tb,te,adj,ytt)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelss 
; -----------------------------------------------------------------
;   Macro        coeffss
; -----------------------------------------------------------------
;   Description  estimates parameters of Subset VAR 
; -----------------------------------------------------------------
;   Usage        b=coeffss(r,icovu,zz,ord,di,tb,te,adj,ytt)  
;   Input
;     Parameter   r  
;     Definition      matrix, restrictions
;     Parameter   icovu 
;     Definition      matrix
;     Parameter   zz  
;     Definition      matrix
;     Parameter   ord 
;     Definition      integer, VAR order
;     Parameter   di  
;     Definition      integer, dimension of time series
;     Parameter   tb 
;     Definition      integer, beginning of sample
;     Parameter   te  
;     Definition      integer, end of sample
;     Parameter   adj
;     Definition      integer, 0=no mean adjustment
;     Parameter   ytt
;     Definition      matrix, time series
;   Output
;     Parameter   b
;     Definition      matrix of estimated coefficient 
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; -----------------------------------------------------------------    
if (sum(r<>0)>0)
   sw=floor(8100/(di*(di*(di*ord+1))))-1
   li=tb-1
   re=min((sw+tb-1)|(te-1))
   b=(kron(icovu,zxgen(ytt,li,re,ord,adj)))*vec(ytt[,li+1:re+1]')
   while (re <> (te-1))
      li=re+1; 
      re=min((re+sw)|(te-1))
      b=b+(kron(icovu,zxgen(ytt,li,re,ord,adj)))*vec(ytt[,li+1:re+1]')
   endo
   b=r*inv(r'*(kron(icovu,zz))*r)*r'*b
   b=reshape(b,#(ord*di+1,di))'
else 
   b=zeros(di,di*ord+1)
endif
endp
