proc (y) = cosi(x)  

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     epa gau qua tri trian uni
; -----------------------------------------------------------------
;   Macro       cosi
; -----------------------------------------------------------------
;   Description  cosi computes the cosine kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = cosi(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = cosi(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Lijian Yang, 951117   
; -----------------------------------------------------------------

  y = prod((pi/4).*cos((pi/2)*x).*(abs(x).<1),2) 

  
endp  
 
