proc (r, p) = cpolar (x)
; -----------------------------------------------------------------------
; Library      math
;------------------------------------
; See_also     cconj
; -----------------------------------------------------------------------
; Macro        cpolar
; -----------------------------------------------------------------------
; Description  Complex numbers in polar coordinates
; -----------------------------------------------------------------------
; Usage        {r, phi} = cpolar (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  r
;   Definition Radius
;   Parameter  phi
;   Definition Angle
; -----------------------------------------------------------------------
; Example      library("math")
;              {r, phi} = cpolar (complex (1, 1))
;              r
;              phi
; -----------------------------------------------------------------------
; Result       Contents of r
;              [1,]   1.4142 
;              Contents of phi
;              [1,]   0.7854 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  r = sqrt(x.re^2+x.im^2)
  p = atan2(x.im, x.re)
endp



