proc (z) = csin(x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos ccosh cexp cln csinh ctan ctanh csqrt
; -----------------------------------------------------------------------
; Macro        csin
; -----------------------------------------------------------------------
; Description  Complex sine
; -----------------------------------------------------------------------
; Usage        z = csin (x)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              csin (complex (3.1415/2, 0))
; -----------------------------------------------------------------------
; Result       Contents of z.re
; 		         [1,]        1 
;              Contents of z.im 
; 		         [1,]        0 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  re = sin(x.re) .* cosh(x.im)
  im = cos(x.re) .* sinh(x.im)
  z  = list(re, im)
endp



