proc(y)=dentoreg(dendat,binlkm)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     
; -----------------------------------------------------------------------
; Macro        dentoreg
; -----------------------------------------------------------------------
; Description   Transforms density data to a regression data using
;               variance stabilizing transform.
;               Divides the sample space into bins, calculates
;               the counts y_i of observations from every bin, and
;               gives the values 2*sqrt(y_i+3/8) as a regression variable.
; -----------------------------------------------------------------------
; Usage         regdat = dentoreg (dendat, binlkm)
; Input        
;   Parameter  dendat
;   Definition n x p matrix: data matrix of i.i.d. observations.
;   Parameter  binlkm
;   Definition integer >=2: gives number of bins for a single dimension
; Output       
;   Parameter  regdat
;   Definition list, consists of regdat.dep, regdat.ind:
;              regdat.dep is (binlkm^p) x 1 vector, it contains
;              the values of the new response variable,
;              regdat.ind is (binlkm^p) x p matrix, it contains
;              the coordinates of the centers of the bins, these are
;              the new regression variables. 
; -----------------------------------------------------------------------
; Notes         This macro is based on 
;               Donoho, Johnstone, Kerkyacharian, and Picard,
;               Wavelet Shrinkage: Asymptotia?, 1995,
;               J. R. Statist. Soc. B, 57, 301-369, page 327.
;               Here are some values of the new regression variable:
;              2*sqrt(3/8)  =1.224745,
;              2*sqrt(1+3/8)=2.345208,
;              2*sqrt(2+3/8)=3.082207,
;              2*sqrt(3+3/8)=3.674235. 
;               The new data has dimension (binlkm^p) x (p+1) if the
;               original data has dimension n x p.      
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
;              ; generate the density data
;              randomize(1)
;              dendat=uniform(10)~(uniform(10)+1)
;              dendat
;              ; transform the density data to a regression data
;              regdat=dentoreg(dendat,4)
;              regdat
; -----------------------------------------------------------------------
; Result
; Contents of dendat    
; [ 1,] 0.000433 1.927735 
; [ 2,] 0.734705 1.319243 
; [ 3,] 0.024197 1.704184 
; [ 4,] 0.503982 1.916961 
; [ 5,] 0.036124 1.980276 
; [ 6,] 0.117048 1.837946 
; [ 7,] 0.740534 1.158730 
; [ 8,] 0.177876 1.672693 
; [ 9,] 0.136730 1.501657 
; [10,] 0.760207 1.945274 
; Contents of regdat.dep
; [ 1,] 1.224745 
; [ 2,] 1.224745 
; [ 3,] 1.224745 
; [ 4,] 3.082207 
; [ 5,] 2.345208 
; [ 6,] 1.224745 
; [ 7,] 1.224745 
; [ 8,] 1.224745 
; [ 9,] 3.082207 
; [10,] 1.224745 
; [11,] 1.224745 
; [12,] 1.224745 
; [13,] 3.674235 
; [14,] 1.224745 
; [15,] 2.345208 
; [16,] 2.345208 
; Contents of regdat.ind
; [ 1,] 0.095404 1.261423 
; [ 2,] 0.285348 1.261423 
; [ 3,] 0.475292 1.261423 
; [ 4,] 0.665236 1.261423 
; [ 5,] 0.095404 1.466810 
; [ 6,] 0.285348 1.466810 
; [ 7,] 0.475292 1.466810 
; [ 8,] 0.665236 1.466810 
; [ 9,] 0.095404 1.672196 
; [10,] 0.285348 1.672196 
; [11,] 0.475292 1.672196 
; [12,] 0.665236 1.672196 
; [13,] 0.095404 1.877583 
; [14,] 0.285348 1.877583 
; [15,] 0.475292 1.877583 
; [16,] 0.665236 1.877583  
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
xlkm=dim(trans(dendat[1,]))
n=dim(dendat[,1])
xalkumat=matrix(binlkm,xlkm)  ;sis. valien keskipisteet
epsi=0.000001
minvec=min(dendat)-epsi
maxvec=max(dendat)+epsi
;askel:n dim on (1,xlkm)
askel=(maxvec-minvec)/binlkm        ;vali min,max
;askel=(maxvec-minvec)/(binlkm-1)   ;vali min-askel/2,max+askel/2
error(askel<=0,"in some variable there is no variation") 
j=1 while (j<=xlkm)
i=1 while (i<=binlkm)
  xalkumat[i,j]=minvec[1,j]+askel[1,j]/2+(i-1)*askel[1,j] ;xalkumat[i,j]=minvec[1,j]+(i-1)*askel[1,j]
i=i+1 endo
j=j+1 endo 
nuusi=binlkm^xlkm
xmat=matrix(nuusi,xlkm)  ;lopullinen data
j=1
while (j<=xlkm)
;  
;dimcatvec=binlkm^(j-1)   ;replkm=binlkm^(j-1) catvec=matrix(dimcatvec,1)
;catmat=matrix(dimcatvec,binlkm)
;k=1
;while(k<=binlkm)
;catmat(,k)=xalkumat(k,j)*matrix(binlkm^(j-1))
;k=k+1
;endo
; 
dimcatvec=binlkm^(j-1)
dimcatcatvec=binlkm^j    ;replkm*binlkm
catcatvec=matrix(dimcatcatvec)
k=1
while (k<=binlkm)
 apucat=xalkumat[k,j]*matrix(binlkm^(j-1))  ;=catmat(,k)
 catcatvec[(k-1)*dimcatvec+1:k*dimcatvec]=apucat
 k=k+1
endo
k=1
while (k<=binlkm^(xlkm-j))
 xmat[(k-1)*dimcatcatvec+1:k*dimcatcatvec,j]=catcatvec
 k=k+1
endo
j=j+1 
endo
;luodaan vastemuuttuja
yres=matrix(nuusi)-1
i=1
while (i<=n)
 j=1 
 apu=1
 while (j<=xlkm)
    in=xlkm-j+1
    l=0
    do
       l=l+1  ;(l<=binlkm)
    until ((dendat[i,in]>=xalkumat[l,in]-askel[1,in]/2) && (dendat[i,in]<=xalkumat[l,in]+askel[1,in]/2))
    apu=apu+(l-1)*binlkm^(in-1)    
;binlkm^j=dimcatcatvec
 j=j+1
 endo
 yres[apu]=yres[apu]+1
i=i+1
endo
dep=2*sqrt(yres+3/8)
ind=xmat
y=list(dep,ind)
endp
