proc(d) = discrim(x1, x2, x)
; ----------------------------------------------------------------------
; Library 	  xclust
; ----------------------------------------------------------------------
;  See_also	aerlb lpdist distance
; ----------------------------------------------------------------------
;   Macro	  discrim
; ----------------------------------------------------------------------
;   Description   computes the discrimination function for an obs x given samples x1 and x2
; ----------------------------------------------------------------------
;   Usage         d = discrim(x1, x2, x)
;   Input 
;     Parameter   x1 
;     Definition  n1 x p  matrix (sample 1)
;     Parameter   x2
;     Definition  n2 x p  matrix (sample 2)
;     Parameter   x
;     Definition  p x 1  vector (the obs to be classified)
;   Output
;     Parameter   d
;     Definition  1 x 2 vector (the distance to the two samples)
;   Note
;    It is assumed that both samples have identical cov structure
; ----------------------------------------------------------------------
;   Example       library("xplore")
;	         library("xclust")
;                        x1 = normal(100, 2)
;	         x2 = normal(100, 2) + 0.8
;	         x   = normal(2) + 0.6   	
; 	         d   = discrim(x1, x2, x)
;                        d
; ----------------------------------------------------------------------
;   Result
;                 [1,] 0.720965 0.030024 
;                
; ----------------------------------------------------------------------
;   Author      Wolfgang Hrdle, 980221
; ----------------------------------------------------------------------
// computes the discrimination function for a new obs x given cov structures of x1, x2
error (cols(x1) <> cols(x2), "PROC DISCRIM: rows of both data sets must be equal") 
// compute the number of obs for each population
  n1 = rows(x1)
error(n1 <= 2,"PROC DISCRIM: number of rows of x1 must at least 3")
  n2 = rows(x2)
error(n2 <= 2,"PROC DISCRIM: number of rows of x2 must at least 3")
// compute cov matrices for each population
  s1 = cov(x1)
  s2 = cov(x2)
  s = (s1*n1 + s2*n2)./(n1 + n2 -2)
  si = inv(s)
  m1 = mean(x1)
  m2 =mean(x2)
  d1 = (x - m1')'*si*(x - m1')
  d2 = (x - m2')'*si*(x - m2')
  d = d1~d2
endp