proc(wr, wi, z)=eisrg(a)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; Macro        eisrg
; -----------------------------------------------------------------------
; Description  Computes the eigenvalues and eigenvectors of a real 
;              general matrix       
; -----------------------------------------------------------------------
; Notes        If the j-th eigenvalue is real, the j-th column of z 
;              contains its eigenvector. If the j-th eigenvalue is 
;              complex with positive imaginary part, the j-th and (j+1)-th
;              columns of  z  contain the real and imaginary parts of its
;              eigenvector.  The conjugate of this vector is the eigen-
;              vector for the conjugate eigenvalue.
; -----------------------------------------------------------------------
; Keywords     eigen values, eigen vectors, real general matrix
; -----------------------------------------------------------------------
; Usage       {wr, wi, z} = eisrg(a)
; Input     
;  Parameter  a
;  Definition n x n matrix
; Output    
;  Parameter  wr
;  Definition n x 1 vector of real eigenvalues
;  Parameter  wi
;  Definition n x 1 vector of imaginary eigenvalues
;  Parameter  z
;  Definition n x n matrix of eigenvectors. 
; -----------------------------------------------------------------------
; Example    
;        library("math")
;        a = #(2, -2)~#(4, 6)
;        {wr, wi, z} = eisrg(a)
;        wr
;        wi
;        z
; -----------------------------------------------------------------------
; Result Contents of wr
;
;        [1,]        4 
;        [2,]        4 
;        Contents of wi
;
;        [1,]        2 
;        [2,]       -2 
;        Contents of z
;
;        [1,]        1        1 
;        [2,]        0        1 
; -----------------------------------------------------------------------
; Author    Fabian Noetzel
; -----------------------------------------------------------------------
  
  os=getenv("os")
  if (os=="windows")
    h = dlopen("eispack.dll")
  else                                         ; Unix
    h = dlopen("eispack.so")
  endif
  
  wr = matrix(rows(a))      
  wi = matrix(rows(a))
  z = a.*NaN               
  
  nm = rows(a) 
  n = cols(a)
  matz =1
  
  param = list(nm, n, a, wr, wi, matz, z)
  byrow = 0|0|0|0|0|0|0
  type = -8|-8|8|8|8|-4|8
  opt = list(type, byrow)
  
  if (os=="windows")
    err = dlcallex(h, "_rg", param, opt)
  else
    err = dlcallex(h, "rg", param, opt) 
  endif
 
  id = "eisrg"
  ErrDLL(err, id)
  
  wr=param.wr
  wi=param.wi
  z=param.z
  
  dlclose(h)
  
endp
