 
proc (y) = epa(x) 

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     cosi gau qua tri trian uni
; -----------------------------------------------------------------
;   Macro       epa
; -----------------------------------------------------------------
;   Description  epa computes the epanechnikov kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = epa(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = epa(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Isabel Proenca & Lijian Yang, 951117   
; -----------------------------------------------------------------


  y = prod(0.75.*(1-x^2).*(abs(x).<1),2)  
 
endp    

