proc(rotm,tourparam)=eppnh(tourparamin, x)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        eppnh
; -----------------------------------------------------------------------
; Description  Optimizes the Hermite index.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.enht<0.01)
    tourparam.enht = 1    
  endif
  p = rows(tourparam.enhrot)
  tourparam.enht = tourparam.enht * (1-tourparam.enhdt)
  rotm = orthonormal(tourparam.enhrot + tourparam.enht.*normal(p,p))
  px   = x*rotm[,1:2]
  h    = tourparam.enhh.*matrix(1,2)
  ind  = indexnaturalhermite(px, h)
  if (ind>tourparam.enhind)
    tourparam.enhind = ind
    tourparam.enhrot = rotm
  else
    rotm = tourparam.enhrot
  endif
endp
