proc(y) = ewinn(t,p)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC
; -----------------------------------------------------------------
;   Macro        ewinn
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;                     calculates E[ u min(t,u) ] 
;                     for u square root of a Chi^2_p-variable, 
;                     (recursively in dimension p)
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          y=ewinn(t,p)
;   Input
;     Parameter   t
;     Definition     numeric; clipping height
;     Parameter   p
;     Definition     integer; dimension of X
; Output                                                           
;     Parameter   y
;     Definition     numeric; y=E[ u min(t,u) ] 
; -----------------------------------------------------------------
; Notes
;      Not to be used outside of rICfil!
; 
;      Is called by 
;                   numint2 numint2m stointp stointpm.
; 
;      Calles [within kalman.lib] 
;                  betrnormE betrnormV.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
gr=30
 
 
vu=betrnormV(t,p)
eu=betrnormE(t,p)
eg=betrnormE(gr,p)
 
y= t.*(eg-eu)+vu	
endp
