proc(y) = genarma(a,b,eps)
; --------------------------------------------------------------
; Library	  times
; --------------------------------------------------------------
;  See_also	  genarch
; --------------------------------------------------------------
;   Macro 	  genarma 
; --------------------------------------------------------------
;   Description	  generates an autoregressive moving average 
;   		  process with mean zero
; --------------------------------------------------------------
;   Usage	  y = genarma(a, b, eps)
;   Input 
;     Parameter   a
;     Definition  p-vector of autoregressive parameters
;     Parameter   b
;     Definition  q-vector of moving average parameters
;     Parameter   eps
;     Definition  n-vector of noise
;   Output
;     Parameter   y
;     Definition  n-vector, the ARMA process
; --------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 genarma(0.1,0.1,normal(5))
; --------------------------------------------------------------
;   Result        Contents of y 
;                 [1,] -0.21293 
;                 [2,]  -1.0504 
;                 [3,]   1.7444 
;                 [4,] -0.93571 
;                 [5,]  -1.6582 
; --------------------------------------------------------------
;   Author        Christian Hafner, 960819
; --------------------------------------------------------------
  p = rows(a)    ; autoregressive order
  q = rows(b)    ; moving average order
  n = rows(eps)  ; length of process
  y = matrix(n)
  ma=eps
  y[1] = eps[1]
  m = max(p|q)
  i = 1
  while(i<=m)    ; loop for starting values
    ma[i+1]=eps[i+1]+b[1:min(i|q)]'*eps[i:max(1|i-q+1)]
    y[i+1] = ma[i+1]+a[1:min(i|p)]'*y[i:max(1|i-p+1)]
    i = i+1
  endo
  j=1            ; loop for moving average
  while(j<=q)
    ma[m+2:n] = ma[m+2:n]+b[j].*eps[m+2-j:n-j]
    j=j+1
  endo
  y = genar(ma, y[1:p], a)
endp
