proc()=glmout(code,x,y,b,bv,stat,opt)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmest glmstat doglm 
; ----------------------------------------------------------------------------
;   Macro       glmout
; ----------------------------------------------------------------------------
;   Description  glmout creates a nice output display for GLM.
; ----------------------------------------------------------------------------
;   Link   ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        glmout(code,x,y,b,bv,stat{,opt})
;   Input
;     Parameter   code  
;     Definition        text string, the short code for the model (e.g. 
;                       "bilo" for logit or "noid" for ordinary PLM).
;     Parameter   x  
;     Definition        n x p  matrix, the predictor variables.
;     Parameter   y  
;     Definition        n x 1  vector, the response variables.
;     Parameter   b
;     Definition        p x 1, estimated coefficients.
;     Parameter   bv
;     Definition        p x p, estimated covariance of b.
;     Parameter   stat
;     Definition        list, containing statistics produced by glm
;                       macros.
;     Parameter   opt
;     Definition        optional, a list with optional input. The macro
;                       "glmopt" can be used to set up this parameter.
;                       The order of the list elements is not important.
;                       Parameters which are not given are replaced by 
;                       defaults (see below).
;     Parameter   opt.weights
;     Definition        string, type of weights. Can be "frequency"
;                       for replication counts, or "prior" (default)
;                       for prior weights in weighted regression.
;     Parameter   opt.wx
;     Definition        scalar or n x 1 vector, frequency or prior 
;                       weights. If not given, set to 1.
;     Parameter   opt.off  
;     Definition        scalar or n x 1 vector, offset in linear predictor.
;                       If not given, set to 0.
;     Parameter   opt.pow
;     Definition        scalar, power for power link. If not given, set 
;                       to 0 (logarithm).
;     Parameter   opt.nbk
;     Definition        scalar, extra parameter k for negative binomial
;                       distribution. If not given, set to 1 (geometric 
;                       distribution).
;     Parameter   opt.nopic
;     Definition        integer, if exists and =1, the output display
;                       is not produced.
;     Parameter   opt.name
;     Definition        string, prefix for the output. If not given, "glm"
;                       is used.
;     Parameter   opt.xvars
;     Definition        p x 1 string vector, variable names for the output. 
;                       Note, that only up to 15 characters are used.
;     Parameter   opt.title
;     Definition        string, title for the output. If not given, a default
;                       is set.
;   Output
;     Parameter   glmOutput
;     Definition        or  opt.name+"Output",
;                       display, containing estimation result in the left
;                       panel and a plot of the index x*b{+off} vs. y 
;                       (vs. y./wx for binomials) and a plot of the index
;                       vs. the link function.
;     Parameter   glmout  
;     Definition        or  opt.name+"out",
;                       string vector, global, containing estimation result 
;                       in the left panel as text.
; ----------------------------------------------------------------------------
;   Example   library("glm") 
;             n=100
;             b=1|2
;             p=rows(b)
;             x=2.*uniform(n,p)-1
;             y=x*b+normal(n)./2
;             {b,bv,stat}=glmest("noid",x,y)
;             glmout("noid",x,y,b,bv,stat)
; ----------------------------------------------------------------------------
;   Result    After fitting a linear regression with glmest, a display
;             is created, which contains the estimated coefficients,
;             their standard errors and t-values as well as the statistics
;             determined by glmest on the left panel. The right panel
;             of the display shows a plot of x*b vs. y together with
;             a plot of x*b vs. the link function.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
; classify our algo
;
  glmmodels=getglobal("glmmodels")
;
  binomial  = sum(code==(glmmodels.binomial)) >0
  nbinomial = sum(code==(glmmodels.nbinomial)) >0
  power     = sum(code==(glmmodels.power)) >0
  twoparfam = sum(code==(glmmodels.twoparfam)) >0
;
; check initial errors
;
  havearray=(rows(dim(x))>2)
  error(havearray,"x must be vector or matrix")
  error(rows(x)!=rows(y),"x and y have different number of rows")
  error((rows(dim(y))>1),"y must be a vector")
;
  n=rows(x)
  p=cols(x)
;
  error(rows(dim(b))>1,"b must be vector")
  error(rows(dim(bv))>2,"bv must be matrix")
  error(rows(b)!=p,"b and x have incompatible dimensions")
  error(dim(bv)!=(p|p),"b and bv have incompatible dimensions")
;
  wx=1
  off=0
  pow=0
  nbk=1
  nopic=0
  name="glm"
  xvars=" "
  havexvars=0
  weights="prior"
;
; now check which optional values have been given
;
  if (exist(opt)>0)
    if (comp(opt,"wx")>0)
      notgood=(exist(opt.wx)!=1)
      notgood=notgood || (rows(dim(opt.wx))!=1)
      notgood=notgood || (dim(dim(opt.wx))!=1)*(rows(opt.wx)!=n)
      notgood=notgood || ((sum(abs(wx))==0) || (min(wx)<0))
      warning(notgood>0, "opt.wx was unusable, used opt.wx=1 instead")
      if (notgood==0)
        wx=opt.wx
      endif
    endif
    if (comp(opt,"weights")>0)
      notgood=(exist(opt.weights)!=2)
      error(notgood>0, "wrong type of weights in opt.weights!")
      if (notgood==0)
        weights=opt.weights
      endif
    endif
    if (comp(opt,"off")>0)
      notgood=(exist(opt.off)!=1)
      notgood=notgood || (rows(dim(opt.off))!=1)
      notgood=notgood || (dim(dim(opt.off))!=1)*(rows(opt.off)!=n)
      warning(notgood>0, "opt.off was unusable, used off=1 instead")
      if (notgood==0)
        off=opt.off
      endif
    endif
    if (comp(opt,"pow")>0)
      notgood=(exist(opt.pow)!=1)
      notgood=notgood || (dim(dim(opt.pow))!=1)
      warning (notgood>0, "opt.pow was unusable, used default =0 instead")
      if (notgood==0)
        pow=opt.pow
      endif
    endif
    if (comp(opt,"nbk")>0)
      notgood=(dim(dim(opt.nbk))!=1)
      warning (notgood>0, "opt.nbk was unusable, used default =1 instead")
      if (notgood==0)
        nbk=opt.nbk
      endif
    endif
    if (comp(opt,"nopic")>0)
      notgood=(exist(opt.nopic)!=1)
      warning (notgood>0, "opt.nopic not a number, used default instead")
      if (notgood==0)
        nopic=(opt.nopic==1)*(dim(dim(opt.nopic))==1)
      endif
    endif
    if (comp(opt,"name")>0)
      notgood=(exist(opt.name)!=2) || (dim(dim(opt.name))!=1)
      warning (notgood>0, "opt.name not a single string, used default instead")
      if (notgood==0)
        name=opt.name
      endif
    endif
    if (comp(opt,"xvars")>0)
      notgood=(exist(opt.xvars)!=2) || (rows(dim(opt.xvars))!=1)
      notgood=notgood || (rows(opt.xvars)!=p)
      warning (notgood>0, "opt.xvars not consistent with x")
      if (notgood==0)
        xvars=opt.xvars
        havexvars=1
      endif
    endif
    if (comp(opt,"title")>0)
      notgood=(exist(opt.title)!=2) || (dim(dim(opt.title))!=1)
      warning (notgood>0, "opt.title not a single string, used default instead")
      if (notgood==0)
        title=opt.title
      endif
    endif
  endif
;
  titl="GLM fit, '"+code+"', n="+string("%1.0f",n)
  if (exist(title)>0)
    txt=    "==================================="
    txt=txt|(" "+title)
    txt=txt|"==================================="
    txt=txt|(" ")
    txt=txt|(" "+titl)
  else    
    txt=    "==================================="
    txt=txt|(" "+titl)
    txt=txt|"==================================="
  endif
;
  if (power)
    txt=txt|" power = "+string("%8.4g",pow)
  txt=txt|"==================================="
  endif
  if (nbinomial)
    txt=txt|" k = "+string("%8.4g",nbk)
  txt=txt|"==================================="
  endif
;
  havenote=0
  iconst=minind(abs(max(x)-min(x)),2)
  if (max(x[,iconst])-min(x[,iconst]) ==0)
    if (havexvars)
      note = " * constant variable: "+paf(xvars,(1:p)==iconst)
    else
      note = " * constant variable: "+string("b[%-1.0f]",iconst)
    endif
    havenote=1
  endif
;
  txt=txt|(" ")|("Estimates (b, s.e., t-value) ")|(" ")
  if (havexvars)
    labl=xvars+"                  "
    labl=substr(labl,1,16)
    blank=string(" ",1:rows(labl))
    lablnew=substr(labl,1,2)
    j=1
    while (j<15)
      j=j+1
      sub=substr(labl,j,j+1)
      if (1-prod(sub==blank)) 
      lablnew=lablnew+sub
      endif
    endo
    labl=lablnew   
  else
    if (rows(b)<10)
      labl=string(" b[%-1.0f]",1:rows(b))
    else
      labl=string(" b[%-1.0f] ",1:9)
      labl=labl|string(" b[%-1.0f]",10:rows(b))
    endif
  endif
  bstr=string(" %10.6g",b)
  sstr=" "
  tstr=" "
  if (exist(stat.serror))
    sstr=string(" %-8.4g",stat.serror)
  endif
  if (exist(stat.tvalue))
    tstr=string(" %6.2f",stat.tvalue)
  endif
  txt=txt|(labl+bstr+sstr+tstr)
  if (havenote)
    txt=txt|(" ")|note
  endif
;
  havenote=0
  txt=txt|(" ")|("Statistics")
  namestat=" "
    if (comp(stat,"df")>0)
      if (exist(stat.df)==1)
        namestat=namestat|(" df             "+string("%12.0f",stat.df))
      endif
    endif
    if (comp(stat,"deviance")>0)
      if (exist(stat.deviance)==1)
        namestat=namestat|(" Deviance       "+string("%12.4f",stat.deviance))
      endif
    endif
    if (comp(stat,"loglik")>0)
      if (exist(stat.loglik)==1)
        namestat=namestat|(" Log-Likelihood "+string("%12.4f",stat.loglik))
      endif
    endif
    if (twoparfam)
    if (comp(stat,"dispersion")>0)
      if (exist(stat.dispersion)==1)
        namestat=namestat|(" Dispersion     "+string("%12.4f",stat.dispersion))
      endif
    endif
    endif
    if (comp(stat,"pearson")>0)
      if (exist(stat.pearson)==1)
        namestat=namestat|(" Pearson        "+string("%12.4f",stat.pearson))
      endif
    endif
    if (comp(stat,"r2")>0)
      if (exist(stat.r2)==1)
        namestat=namestat|(" R^2            " +string("%12.4f",stat.r2))
      endif
    endif
    if (comp(stat,"adr2")>0)
      if (exist(stat.adr2)==1)
        namestat=namestat|(" adj. R^2       "+string("%12.4f",stat.adr2))
      endif
    endif
    if (comp(stat,"aic")>0)
      if (exist(stat.aic)==1)
        namestat=namestat|(" AIC            "+string("%12.4f",stat.aic))
      endif
    endif
    if (comp(stat,"bic")>0)
      if (exist(stat.aic)==1)
        namestat=namestat|(" BIC            "+string("%12.4f",stat.bic))
      endif
    endif
    if (comp(stat,"it")>0)
      if (exist(stat.it)==1)
        if (stat.it>0)
          namestat=namestat|(" iterations     "+string("%12.0f",stat.it))
        endif
      endif
    endif
    if (comp(stat,"nr")>0)
      if (exist(stat.nr)==1)
        namestat=namestat|(" distinct obs.  "+string("%12.0f",stat.nr))
      endif
    endif
    if (comp(stat,"ret")>0)
      if (exist(stat.ret)==1)
        if (stat.ret==-1)
          note = " ! missing values occurred"
          havenote=1
        endif
        if (stat.ret==1)
          note = " ! max. number of iterations reached"
          havenote=1
        endif
      endif
    endif
    txt=txt|namestat
    if (havenote)
      txt=txt|(" ")|note
    endif
  exec(name+"out=txt")
  putglobal(name+"out")
;
  if (nopic!=1)
    if (binomial)
      if (weights=="prior")
        if (max(y[,1])>1)
          y = y[,1]./(wx+(wx==0))
        endif
      endif
    endif
    eta=sort((x*b+off)~y)
    if (rows(wx)>1)
      eta=paf(eta,wx>0)
      wx =paf( wx,wx>0)
    endif
    y  =eta[,2]
    eta=eta[,1]
    mu=glmlink(code,eta,list(pow,nbk))
    etamu=eta~mu
    etay =eta~y
;
    line=(1:n)'
    setmaskl(etamu,line,2,1,4)
    setmaskp(etay,4,11,8)
    setmaskp(etamu,2,1,8)
;
    exec( name+"Output=createdisplay(1,2)" )
    exec( "show("+name+"Output,1,2,etamu,etay)" )
    tl="title"
    xl="xlabel"
    yl="ylabel"
    ymaj="ymajor"
    ym=(max(max(mu)|max(y))-min(min(mu)|min(y)))./5
    xlabl="Index eta"
    ylabl="Link mu, Responses y"
    exec("show("+name+"Output,1, 1, txt)")
    if (exist(title)>0)
      exec( "setgopt("+name+"Output,1,2,tl,title,xl,xlabl,yl,ylabl,ymaj,ym)" )
    else
      exec( "setgopt("+name+"Output,1,2,tl,titl,xl,xlabl,yl,ylabl,ymaj,ym)" )
    endif
  else
    exec(name+"out") ; text output to XploRe_out
  endif
endp









