proc(fh)=grash(x, h, k, col)   
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grdot grdotd grhist
; -----------------------------------------------------------------------
; Macro        grash
; -----------------------------------------------------------------------
; Description  Generates an averaged shifted histogram.
; -----------------------------------------------------------------------
; Usage        fh = grash (x, {h, {k, {col}}})
; Input
;   Parameter  xr 
;   Definition n x 1      vector
;   Parameter  h
;   Definition scalar     binwidth
;   Parameter  k          
;   Definition scalar     number of shifts
;   Parameter  col
;   Definition color
; Output
;   Parameter  fh
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grash (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows the average shifted histogram
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, histogram
; -----------------------------------------------------------------------
; Author       Marlene Mueller, Sigbert Klinke, 9704
; -----------------------------------------------------------------------
  error (cols(x)<>1, "grash : cols(x)<>1")
  error (rows(x)<2,  "grash : rows(x)<2")
  if (exist("h").<>1)
    h = sqrt(var(x))./2
  endif
  if (exist("k").<>1)
    k = 50
  endif
  if (exist("col").<>1)
    grc = getglobal("grc")
    col = grc.col.black
  endif
  d=h/k
  {xb, yb} = bindata(x, d, 0) 
  wx=0:(k-1)
  wy=k:1
  {xc,yc,or}=conv(xb,yb,wx,wy)
  n=rows(xc)
  ind=reshape((1|1)*(1:n)',2*n|1)  ; double entries
  xc=xc[ind]
  yc=yc[ind]  
  mm=reshape((-0.5|0.5)*matrix(1,n),2*n|1)
  xc=d*(xc+mm)
  fh=xc~(yc./(rows(x)*h*k))
  setmaskl(fh, (1:rows(fh))', col, 1, 1)
  setmaskp(fh, 0, 0, 0)
endp  