proc(bp)=grboxgrouped(ug,og,n,col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbox grboxmean grboxmedian
; -----------------------------------------------------------------------
; Macro        grboxgrouped
; -----------------------------------------------------------------------
; Description  Generates a boxplot for grouped data with mean line (dotted)
;              and median line (solid).
; -----------------------------------------------------------------------
; Usage        bp = grboxgrouped (ug, og, n {, col})
; Input
;   Parameter  ug
;   Definition p x 1      sorted vector of lower borders of group
;   Parameter  og
;   Definition p x 1      sorted vector of upper borders of group
;   Parameter  n
;   Definition p x 1      vector of absolute or relative frequencies of group
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Note				 It is not checked if the borders are in sorted order or
;              if relative frequencies add up to one.
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              // structure of age of women in west germany 31.12.95
;              ug = #(0, 15, 40, 65)
;              og = #(15, 40, 65, 80) 
;              t  = #(5326, 11911, 10725, 6735)
;              bp = grboxgrouped (ug, og, t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a boxplot for grouped data
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, boxplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 981123
; -----------------------------------------------------------------------
  error(cols(ug)<>1, "grboxgrouped : cols(ug)<>1")
  error(cols(ug)<>1, "grboxgrouped : cols(og)<>1")
  error(cols(n).<>1, "grboxgrouped : cols(n)<>1")
  error(rows(n)<>rows(og), "grboxgrouped : rows(n)<>rows(og)")
  error(rows(n)<>rows(ug), "grboxgrouped : rows(n)<>rows(ug)") 
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  F   = 0|(cumsum(n)./sum(n))
F
  i   = sum((F-0.25)<0)
  if (i>=rows(n))
    i = rows(n)-1
  endif
  q25 = ug[i]+(0.25-F[i])/(F[i+1]-F[i])*(og[i]-ug[i])
  i   = sum((F-0.50)<0)
  if (i>=rows(n))
    i = rows(n)-1
  endif
  q50 = ug[i]+(0.50-F[i])/(F[i+1]-F[i])*(og[i]-ug[i])
  i   = sum((F-0.75)<0)
  if (i>=rows(n))
    i = rows(n)-1
  endif
  q75 = ug[i]+(0.75-F[i])/(F[i+1]-F[i])*(og[i]-ug[i])
  mx  = sum(0.5.*(ug+og).*n./sum(n))
  iqr = 1.5.*(q75-q25)
  lf  = q25-iqr
  if (lf<ug[1])
    lf = ug[1]
  endif
  uf = q75+iqr
  if (uf>og[rows(n)])
    uf = og[rows(n)]
  endif
;;  
  bp = (lf~0)|(lf~1)
  bp = bp|((q25~0)|(q25~1))
  bp = bp|((q50)~0|(q50~1))
  bp = bp|((q75)~0|(q75~1))
  bp = bp|((uf~0)|(uf~1))
  bp = bp|((mx~0)|(mx~1))
  bp = bp|((lf~0.5)|(q25~0.5)|(q75~0.5)|(uf~0.5)) 
  bll = #(1,3,5,7,9,11,13,15,3,5,4,6)~#(2,4,6,8,10,12,14,16,5,7,6,8)
  bal = #(1,1,1,1,1,3,1,1,1,1,1,1)
  setmaskl (bp, bll, col, bal, 1*matrix(rows(bll)))
  setmaskp (bp, 0, 0, 0)
  values = lf|q25|q50|q75|uf|mx
  append(bp, values)
endp  
