proc(bp)=grboxmean(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbox grboxmedian
; -----------------------------------------------------------------------
; Macro        grboxmean
; -----------------------------------------------------------------------
; Description  Generates a boxplot with the mean line. The box borders are
;              plus/minus one standard deviation of the mean line and the
;              whiskers are plus/minus two standard deviations.
; -----------------------------------------------------------------------
; Usage        bp = grboxmean (x {, col})
; Input
;   Parameter  x
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grboxmean (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a "normal" boxplot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, boxplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  error(cols(x).<>1, "grbox : cols(x)<>1")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  xs  = sort(x)
  q50 = mean(x)
  sd  = sqrt(var(x)) 
  q25 = q50-sd
  q75 = q50+sd
  lf  = q50-2*sd
  uf  = q50+2*sd
  bp = ((lf~0)|(lf~1))
  bp = bp|((q25~0)|(q25~1))
  bp = bp|((q50)~0|(q50~1))
  bp = bp|((q75)~0|(q75~1))
  bp = bp|((uf~0)|(uf~1))
  bp = bp|((lf~0.5)|(q25~0.5)|(q75~0.5)|(uf~0.5))
  li = reshape((1:14)', #(2,7))'|(4~8)|(3~7) 
  setmaskl (bp, li, col, 1, 1)
  setmaskp (bp, 0, 0, 0)
endp