proc(linep)=grcart2(x, tree, ix, iy, mindepth, minssr)
; ---------------------------------------------------------------------
; Library     graphic
; ---------------------------------------------------------------------
; See_also    cartsplit, dispcart2, tree
; ---------------------------------------------------------------------
; Macro       grcart2
; ---------------------------------------------------------------------
; Description produces the cut graphic for a CART tree.
; ---------------------------------------------------------------------
; Usage       line = grcart2(x,tree,ix,iy,mindepth,minssr)
; Input       
; Parameter   x
; Definition  nxp, 	X-variables used in cartsplit
; Parameter   tree
; Definition  list,	result of cartsplit
; Parameter   ix
; Definition  scalar,	which variable is taken for X
; Parameter   iy
; Definition  scalar,	which variable is taken for Y
; Parameter   mindepth
; Definition  scalar,	till which depth the tree should be shown
; Parameter   minssr
; Definition  scalar,	shows all cuts which produce a SSR larger than minssr
; Output      
; Parameter   line
; Definition  list,	a graphical object that contains the cuts
; ---------------------------------------------------------------------
; Notes       The variables x[,ix] and x[,iy] must be continuous.
; ---------------------------------------------------------------------
; Example      randomize(1)
;             n=100
;             ; Generate some simulated data
;             xdat=uniform(n,2)
;             ydat=120.*matrix(n,1)-(xdat[,2]<=0.5).*120-(xdat[,2]>0.5).*(xdat[,1]<=0.5).*20
;             ydat=ydat+normal(n)
;             ; call CART
;             type=#(1,1)
;             opt=cartsplitopt("minsize",1,"mindev",0,"mincut",5)
;             tr=cartsplit(xdat,ydat,type,opt)
;             ; shows cuts
;             d=createdisplay(1,1)
;             show(d, 1,1, xdat, grcart2(xdat, tr, 1, 2, 3, 0))
;
; ---------------------------------------------------------------------
; Result      shows the data and the cuts till depth 3
; ---------------------------------------------------------------------
; Keywords    CART
; ---------------------------------------------------------------------
; Reference   Breiman, L., Friedman, J., Olshen, R., and Stone, C. J. (1984). 
;             Classification and Regression Trees. Chapman & Hall, New York
; ---------------------------------------------------------------------
; Link        ..\tutorials\cartstart.html CART Tutorial
; ---------------------------------------------------------------------
; Author      2000-03-17, Sigbert Klinke
; ---------------------------------------------------------------------
  depth = -1
  error (depth>=mindepth, "grcart : depth>=mindepth")
  xw = x[,#(ix,iy)]
  line = NaN.*matrix(1, 4)
  i = 0
  val = 0
  left  = min(xw)~max(xw) 
  right = -2~left
  linep = NaN.*matrix(1, 2)
  linel = 0~0 
  while (i<rows(tree.vec))
    cmd = string ("val=atof(tree.val.split%.0f)", i)
    exec(cmd)
    i=i+1
    switch
    case (tree.vec[i]==ix)
      depth = depth+1
      if ((tree.ssr[i]>minssr) && (depth<mindepth))
        linel = linel|(rows(linep)+1~rows(linep)+2)
        linep = linep|(val~left[,2])|(val~left[,4]) 
      endif 
      right = right|(depth~val~left[,2:4])
      left  = left[,1:2]~val~left[,4]
      break
    case (tree.vec[i]==iy)
      depth = depth+1
      if ((tree.ssr[i]>minssr) && (depth<mindepth))
        linel = linel|(rows(linep)+1~rows(linep)+2)
        linep = linep|(left[,1]~val)|(left[,3]~val) 
      endif
      right = right|(depth~left[,1]~val~left[,3:4])
      left  = left[,1:3]~val
      break
    case (isNaN(tree.vec[i]))
      nr = rows(right)
      depth = right[nr,1]
      left = right[nr,2:5]
      nr = nr-1
      if (nr>0)
        right = right[1:nr,]
      endif
      break
    default
      right = right|(depth~left)
    endsw 
  endo
  setmaskp (linep, 0,0,0)
  setmaskl (linep, linel) 
endp
