proc(gs)=grcontour2(x, c, col) 
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grlinreg2 grsurface grcontour3 contour2
; -----------------------------------------------------------------------
; Macro        grcontour2
; -----------------------------------------------------------------------
; Description  Generates a contour plot from a 3-dimensional dataset x.
; -----------------------------------------------------------------------
; Usage        gs = grcontour2 (x, c, {, col})
; Input
;   Parameter  x
;   Definition n x 3 matrix 
;   Parameter  c
;   Definition m x 1 vector 
;   Parameter  col
;   Definition m x 1 color
; Output
;   Parameter  gs
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = grid (#(-3,-3), #(0.25,0.25), #(25,25))
;              f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi)
;              c  = (1:9).*max(f)./10
;              gs = grcontour2 (x~f, c)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, gs)
; -----------------------------------------------------------------------
; Result       shows a contour plot 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, contour plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961001
; -----------------------------------------------------------------------
  error (cols(x).<>3, "grcontour2 : cols(x)<>3")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black.*matrix(rows(c))
  endif
  error (rows(c).<>rows(col), "grcontour2 : rows(c)<>rows(col)")
; find x coordinates
  xs = sort(x, #(1,2,3))
  i  = 0
  while (i.<rows(c))
    i = i+1
    if (i.=1)
      {lt, pt} = contour2 (xs, c[i])
      lc = col[i].*matrix(rows(lt))
    else
      {lti, pti} = contour2 (xs, c[i])
      lci = col[i].*matrix(rows(lti))
      lc  = lc|lci
      lt  = lt|(lti+rows(pt))
      pt  = pt|pti
    endif
  endo
  gs = pt
  setmaskp (gs, 0, 0, 0)
  setmaskl (gs, lt, lc, 1, 2)
endp
