proc(dp)=grdot(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grhist grash
; -----------------------------------------------------------------------
; Macro        grdot
; -----------------------------------------------------------------------
; Description  Generates a dotplot.
; -----------------------------------------------------------------------
; Usage        bp = grdot (x {, col})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grdot (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a dotplot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, dotplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
   error(cols(x).<>1, "grdot : cols(x)<>1")
   if (exist("col").<>1)
     grc = getglobal ("grc")  
     col = grc.col.black
   endif
   dp = x~uniform(rows(x))
   setmaskp (dp, col, 3, 4) 
endp