proc(gl)=grlinreg2(xo, n, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grsurface grlinreg grcontour2
; -----------------------------------------------------------------------
; Macro        grlinreg2
; -----------------------------------------------------------------------
; Description  generates a graphical object
;              which contains a linear regression plane from the data.
;              The plane is computed on a rectangular grid with n^2
;              meshes.
; -----------------------------------------------------------------------
; Usage        gl = grlinreg2 (x, {n, {col}})
; Input
;   Parameter  x
;   Definition m x 3 matrix 
;   Parameter  n
;   Definition 2 x 1 matrix 
;   Parameter  col
;   Definition color
; Output
;   Parameter  gl
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = normal(100,2)
;              y  = 3*x[,1]+5*x[,2]+normal(100)
;              l  = grlinreg2(x~y)
;              d  = createdisplay(1,1)
;              show(d,1,1,x~y,l)
; -----------------------------------------------------------------------
; Result       shows the data and the linear regression plane
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, linear regression
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961005
; -----------------------------------------------------------------------
  error (cols(xo)<>3, "grlinreg2 : cols(x)<>3")
  if (exist("n")<>1)
    n = 25|25
  endif
  error (rows(n)<>2, "grlinreg2 : rows(n)<>2")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  x  = xo[,1:2]
  xi = min(x)
  xa = max(x)
  y  = xo[,3]
  x  = x~matrix(rows(x))
  b  = gls(x,y)
  xb = grid(xi', (xa-xi)'./(n-1), n) 
  yb = (xb~matrix(rows(xb)))*b
  gl = grsurface(xb~yb, col)
endp