proc(piedata)=grpie(x)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grcirclesector
; -----------------------------------------------------------------------
; Macro        grpie
; -----------------------------------------------------------------------
; Description  Generates a pie chart from the data.
; -----------------------------------------------------------------------
; Usage        mypie = grpie (x,[distance])
; Input
;   Parameter  x
;   Definition n x 2      vector
;                         the first column contains the data
;                         the second column contains the frequencies of 
;   Parameter  distance
;   Definition n x 1      vector
;                         contains distances between sectors and origin
; Output
;   Parameter  mypie
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              data = 1:5
;              freqs = 10|2|13|9|6
;              dist = 0|50|0|0|50
;              mypie = grpie (data~freqs~dist)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, mypie)
; -----------------------------------------------------------------------
; Result       shows a pie chart
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, pie chart
; -----------------------------------------------------------------------
; Author       Rodrigo Witzel, 981111
; -----------------------------------------------------------------------
if ((cols(x)<=3) && (cols(x)>=2))
  if (cols(x)==2)
    x=x~(matrix(rows(x))-1)
  endif
  xr=(x[,2]/sum(x[,2]))*(2*pi)
  radius=100
  part=1
  winkel=0
  while (part<=rows(xr))
    grcp=grcirclesector(radius,winkel,winkel+xr[part])
    winkelmitte=winkel+(xr[part]/2)
    grcp=grmove(grcp,#(x[part,3]*sin(winkelmitte),x[part,3]*cos(winkelmitte)))
    if (part==1)
      grcpalllines=grcp.lines ;Linie hinzufgen
      grcpall=grcp.data
      grcppntt=((1.1*radius+x[part,3])*sin(winkelmitte))~((1.1*radius+x[part,3])*cos(winkelmitte))
    else
      grcpline=grcp.lines+rows(grcpall)
      if (cols(grcp.lines)>cols(grcpalllines))
        grcpalllines=grcpalllines~(matrix(rows(grcpalllines),cols(grcpline)-cols(grcpalllines))-1)
      endif
      if (cols(grcp.lines)<cols(grcpalllines))
        grcpline=grcpline~(matrix(1,cols(grcpalllines)-cols(grcpline))-1)
      endif
      grcpalllines=grcpalllines|grcpline
      grcpall=grcpall|grcp.data
      grcppntt=grcppntt|(((1.1*radius+x[part,3])*sin(winkelmitte))~((1.1*radius+x[part,3])*cos(winkelmitte)))
    endif
    winkel=winkel+xr[part]
    part=part+1
  endo
  piedata=grcpall|grcppntt
  setmaskl(piedata,grcpalllines,0,1,1)
  setmaskp(piedata,1,0,1)
  parttext=string("%10.3f",grcpall[,1])|string("%10.3f",x[,1])
  setmaskt(piedata,parttext,4,(matrix(rows(grcpall))-2)|(matrix(rows(grcppntt))-1),12)
else
  warning(((cols(x)>3) || (cols(x)<2)),"grpie: -Error- cols(x)>3 or cols(x)<2")
  piedata=(0~0)
endif
endp
