proc(grout)=grrot(grin, rot)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grmove
; -----------------------------------------------------------------------
; Macro        grrot
; -----------------------------------------------------------------------
; Description  Rotates a graphical object. 
; -----------------------------------------------------------------------
; Usage        grout = grrot (grin, rot) 
; Input
;   Parameter  grin
;   Definition composed graphical object
;   Parameter  rot
;   Definition scalar
; Output
;   Parameter  grout
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Notes        The possible values of rot are 0, 1, 2 or 3. A value of
;              k is equivalent to a rotation of 90k degrees.
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t   = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp1 = grdot (t)
;              bp2 = grrot (bp1, 1)
;              d   = createdisplay (1,1)
;              show (d, 1, 1, bp1, bp2)
; -----------------------------------------------------------------------
; Result       shows a the same dotplot twice, one rotated by 90 degrees
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  grout = grin
  rot = floor(rot)%4
  switch
  case (rot==1)
     tmp = grout[,2]
     grout[,2] = grout[,1] 
     grout[,1] = tmp
     break
  case (rot==2)
     grout[,2] = - grout[,2]
     break
  case (rot==3)
      tmp = grout[,2]
     grout[,2] = grout[,1] 
     grout[,1] = -tmp
     break
  endsw
endp