proc(hp)=grsunflower (x, d, or, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grandrews grpcp grcontour3
; -----------------------------------------------------------------------
; Macro        grsunflower
; -----------------------------------------------------------------------
; Description  Generates a sunflower plot.
; -----------------------------------------------------------------------
; Usage        bp = grsunflower (x, {d, {o, {col}}})
; Input
;   Parameter  xr 
;   Definition n x 1      vector
;   Parameter  d
;   Definition scalar     binwidth
;   Parameter  o
;   Definition scalar     origin
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = normal(10000, 2)
;              bp = grsunflower (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a sunflower plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, sunflower plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961102
; -----------------------------------------------------------------------
  if (exist("d").<>1)
    d = trans(sqrt(var(x))./2)
  endif
  if (exist("or").<>1)
    or = 0.*matrix(cols(x))
  endif
  if (exist("col").<>1)
    grc = getglobal("grc")
    col = grc.col.black
  endif
  {xb, yb} = bindata(x, d, or) 
  xb = paf(xb~yb, yb)
  p  = cols(xb)
  hp = xb[,(1:p-1)].*d'+or'
  yb = 1+floor(14.99.*xb[,p]./max(xb[,p]))
  setmaskp(hp, 0, grc.sym.circle, yb)
endp  
