proc(gs)=grsurface(x, col) 
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grxline gryline grlinreg grlinreg2
; -----------------------------------------------------------------------
; Macro        grsurface
; -----------------------------------------------------------------------
; Description  generates a surface plot from a 3-dimensional dataset.
; -----------------------------------------------------------------------
; Usage        gs = grsurface (x {, col})
; Input
;   Parameter  x
;   Definition n x 3 matrix 
;   Parameter  col
;   Definition color
; Output
;   Parameter  gs
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Notes        The first two coordinates have to be on a grid such that
;              #x-coordinates * #y-coordinates = n. The dataset x need
;              not be sorted in any order.
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = grid (#(-3,-3), #(0.1,0.1), #(61,61))
;              f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi)
;              gs = grsurface (x~f)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, gs)
; -----------------------------------------------------------------------
; Result       shows a surface plot 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, surface plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961001
; -----------------------------------------------------------------------
  error (cols(x).<>3, "grsurface : cols(x)<>3")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
; find x coordinates
  xs = x[,1]
  xs = sort(xs, 0)
  xn = rows(xs)
  xb = xs[1,]
  xs = xs[2:xn,]-xs[1:xn-1,]
  xs = paf(xs, xs.<>0)
  xs = cumsum(xb|xs)
  xn = rows(xs)
; find y coordinates
  ys = x[,2]
  ys = sort(ys, 0)
  yb = ys[1,]
  yn = rows(ys)
  ys = ys[2:yn,]-ys[1:yn-1,]
  ys = paf(ys, ys.<>0)
  ys = cumsum(yb|ys)
  yn = rows(ys)
; check if all points available
  error (rows(x).<>xn*yn, "grsurface : no grid found")
  gs = sort (x, 1:2)
  gn = max(xn|yn)  
  gl = 0.*matrix(xn+yn,gn)
  gl[1:xn,1:yn] = (1:yn)'+grid(0, yn, xn)
  gl[xn+1:xn+yn,1:xn] = (1:yn)+grid(0, yn, xn)'
  setmaskp(gs, 0, 0, 0)
  setmaskl(gs, gl, col, 1, 2)
endp
