proc (bcumhaz,bsurv)=hazcoxb(data)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazregll, hazbeta, hazsurv
; -----------------------------------------------------------------
; Macro       hazcoxb
; -----------------------------------------------------------------
; Description calculates the baseline hazard and survival 
;             function, using the maximum likelihood estimate of 
;             the regression parameter beta obatined through
;             hazbeta. 
; -----------------------------------------------------------------
; Usage       {bcumhaz, bsurv} = hazcoxb(data)
; Input
; Parameter   data 
; Definition  n x (p+4) matrix, 
;             column 1:  the sorted observed survival time t, 
;             column 2:  the cosorted censoring indicator delta,
;             column 3:  labels l,  
;             column 4:  number of ties at time t[i], cosorted,
;             columns 5 to p+4: the cosorted covariate matrix z.
; Output
; Parameter   bcumhaz  
; Definition  n x 2 matrix, 
;             column 1:  the sorted observed survival time t,
;             column 2:  estimated cumulative baseline hazard
;                        function at the points of t.
; Parameter   bsurv  
; Definition  n x 2 matrix, 
;             column 1:  the sorted observed survival time t,
;             column 2:  estimated baseline survival
;                        function at the points of t.
; -----------------------------------------------------------------
; Example  library("hazreg") 
;            n = 20
;            p = 2
;            beta = 1|2                      ; regression parameter
;            z = 1 + uniform(n,p)            ; covariates
;            y = -log(1-uniform(n))          ; exponential survival
;            y = y./exp(z*beta)              ; covariate effects
;            c = 4*uniform(n)                ; uniform censoring
;            t = min(y~c,2)                  ; censored time             
;            delta = (y<=c)                  ; censoring indicator            
;            
;         {data,ties} = hazdat(t,delta, z)   ; preparing data
;         {bcumhaz,bsurv} = hazcoxb(data)  
;                                            ; estimation of the
;                                            ; baseline hazard and
;                                            ; survival functions                              
; -----------------------------------------------------------------
; Result     The baseline hazard and survival functions are 
;            estimated. 
; -----------------------------------------------------------------
; Keywords   baseline hazard, baseline survival function
; -----------------------------------------------------------------
; Author     Lijian Yang, B. Grund 000308
; -----------------------------------------------------------------
  n=rows(data)

  {betahat,betak,ck} = hazbeta(data)

  p = rows(betahat)
  t = data[,1]           ;time
  d = data[,2]           ;censoring indicator

  z = data[,5:p+4]
  zbeta = z*betahat
  ezbeta = exp(zbeta)

  bcumhaz = matrix(n,1)

  i = 1
  while (i<=n)
    inrisk = hazrisk(data,i)
    inrisk = inrisk'
    bcumhaz[i] = inrisk*ezbeta
  i = i + 1
  endo
  
  bcumhaz =  d./bcumhaz

  i = 2
  while (i<=n)
  bcumhaz[i] = bcumhaz[i] + bcumhaz[i-1]
  i = i + 1
  endo

bsurv = exp(-bcumhaz)

bcumhaz = t~bcumhaz
bsurv = t~bsurv
  
endp


