proc (nar)=haznar(data)
; -----------------------------------------------------------------
; Library     hazreg
;------------------------------------------------------------------
; See_also    hazdat, hazrisk
; -----------------------------------------------------------------
; Macro       haznar
; -----------------------------------------------------------------
; Description calculates the size of the risk set at each points  
;             of the censord survival time data.
; -----------------------------------------------------------------
; Usage       nar = haznar(data)
; Input
; Parameter   data  
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time, followed by the sorted censoring
;             indicator, labels l, a column containing the 
;             number of ties, and lastly, the sorted covariate 
;             matrix z. This data is produced by hazdat.xpl.
; Output
; Parameter   nar  
; Definition  n x 1 vector, the ith entry is the size of the 
;             risk set at time t_i. 
; -----------------------------------------------------------------
; Example    library("hazreg") 
;             
;             y = -log(1-uniform(20))         ; exponential survival
;             c = 2*uniform(20)               ; uniform censoring
;             t = min(y~c,2)                  ; censored time             
;             delta = (y<=c)                  ; censoring indicator            
;             
;             {data,ties} = hazdat(t,delta)   ; preparing data
;             nar = haznar(data)              ; calculating the 
;                                               number at risk                                
; -----------------------------------------------------------------
; Result      The size of each risk set is listed as a vector in   
;             same order of the sorted data. 
; -----------------------------------------------------------------
; Example    library("hazreg") 
;             
;             y = 2|1|3|2|4|7|1|3|2        ; hypothetical survival
;             c = 3|1|5|6|1|6|2|4|5        ; hypothetical censoring
;             t = min(y~c,2)               ; censored time             
;             delta = (y<=c)               ; censoring indicator            
;             
;             {data,ties} = hazdat(t,delta) 
;                                          ; preparing data 
;             nar = haznar(data)           ; calculating the number
;                                            at risk             
; -----------------------------------------------------------------
; Result      The same risk set size vector, but this time there   
;             are ties in the vector: three 9's, three 6's, two 3's. 
; -----------------------------------------------------------------
; Keywords    number at risk, survival time, censored data
; -----------------------------------------------------------------
; Author      Lijian Yang 990601
; -----------------------------------------------------------------
  t  = data[,1]
  label = data[,3]
  n=rows(t)
  l = 1:n
  nar = n + 1 - l
  
  i = 2
  while (i<=n)
  if (t[i]==t[i-1])
  nar[i] = nar[i-1]
  endif
  i = i + 1
  endo

  ;nar =  label~nar
  ;nar = sort(nar,1)
  ;nar = nar[,2]

endp


