proc(ra,b,q) = hurst(x, k)
; ---------------------------------------------------------------------
; Library     times
; ---------------------------------------------------------------------
; See_also    fracbrown lo kpss
; ---------------------------------------------------------------------
; Macro       hurst
; ---------------------------------------------------------------------
; Description   estimates the Hurst coefficent of a process using the 
;		R/S statistics
; ---------------------------------------------------------------------
; Usage       (ra,b,q)=hurst(x,k)
; Input       
; Parameter   x
; Definition  n x 1 vector, observations of the process
; Parameter   k
; Definition  scalar, maximal number of intervals for the R/S statistic
; Output      
; Parameter   ra
; Definition  (k-2) x 3 matrix, ra[,1] = (1, ... ,1)', 
;                             ra[,2] = log(n/3, n/4, ... ,n/k)',
;			      ra[,3] = log(RS)
; Parameter   b
; Definition  2 x 1 vector, b[1] = intercept of the R/S-line,
;			    b[2] = slope of R/S line, 
;			    b solves the
;			    regression problem ra[,3] = b[1] + b[2]*ra[,2]
; Parameter   q
; Definition  scalar, residual varince of the regression problem
; ---------------------------------------------------------------------
; Notes      to compute RS, (1, ... , n) is devided into k subintervals
;		and then the rescaled range is computed, see the 
;		references for detailed description
; ---------------------------------------------------------------------
; Example     	randomize(23)
;		func("hurst")		// load macro
;		x=cumsum(normal(500)) 	// simualte a brown. Motion (H = 0.5)
;		h=hurst(x,50)		
;		h.b[2]			// estimated H
; ---------------------------------------------------------------------
; Result      Contents of _tmp
;             [1,]  0.54921 
; ---------------------------------------------------------------------
; Keywords    Hurst, long memory, fractional brownian motion
; ---------------------------------------------------------------------
; Reference   Beran, J. (1994). Statistics for Long-Memory Processes.
;		Chapman and Hall, London
; &nl;
; &nl;
;
; Reference   Hall, P., Hrdle, W., Kleinow, T., Schmidt, P. (1999).
;		Semiparametric bootstrap approach to hypothesis tests and 
;		confidence intervals for the Hurst coefficent
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      W. Hrdle, T. Kleinow
; ---------------------------------------------------------------------
  error (k <= 2      , "HURST: k must not be smaller than 3")
  error (cols(x) > 1 , "HURST: cols(x) must be equal to 1")
//	
  n = rows(x)
  a0 = 3
  a = a0
  ra = matrix(k-a +1,2)  ; tk: contains log(n),(R/s)_{n} (p. 3)
// ********* a->
  while (a <= k)
    n1 = floor(n/a)    ; tk: n1 must be an interger -> floor
    rr = matrix(a)			; contains the rescaled range values
// *********** i->
    i =1
    while (i <= a)
      ri = x[((i-1)*n1 + 1):(i*n1),]	; contains the values of each block
; --- rescaled range computation
      rr[i,] = ( max(ri) - min(ri) )/sqrt( var(ri[2:rows(ri)]-ri[1:rows(ri)-1]) )
      i = i+1
    endo 
// *********** <-i
    ra[a-a0 +1,1] = log(n1)
    ra[a-a0 +1,2] = log(mean(rr))
    a = a + 1
  endo
// ********* <-a
  ra = matrix(rows(ra))~ra
  b = inv( (ra[,1:2])'*ra[,1:2] )*(ra[,1:2])'*ra[,3]
  e = ra[,3] - ra[,1:2]*b
  q = e'*e/(k-2)
endp

