proc()=ira(y,p,adj,variablenames)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  domulti
; ----------------------------------------------------------------------
;   Macro	  ira
; ----------------------------------------------------------------------
;   Description   Generation of menu system for impulse response analysis.
;                 When calling this quantlet a system of menus will appear
;                 on the screen that guides you through the stages of
;                 impulse response analysis for vector autoregressive models.
;
;                 This quantlet defines the following pop-up menus: 
;                 irairmax, iracoverage, irabootci, irayscale, iraimpulse,
;                 iraresponse, iraselectgraph, iramain, iradisplay, irainfodisplay.
;
;                 This quantlet defines the following auxiliary functions:
;                 vector2string, strvector2string, comparevector.
;
;                 The quantlet ira() communicates by one list ('m.*') with the pop-ups.
;                 The succesion of the pop-ups is controlled with two other lists 
;                 ('enter.*' and 'return.*'). All lists are defined in ira().
; ----------------------------------------------------------------------
;   Usage         ira(y,p,adj,variablenames)
;   Input 
;     Parameter   y 
;     Definition     (K x (p+T))-matrix, the multivariate time series (K univariate
;                    series with p+T observations)
;     Parameter   p 
;     Definition     (1 x 1)-matrix, order of the VAR-model
;     Parameter   adj 
;     Definition    scalar, 1=if mean adjusted model, 0=if not
;     Parameter   variablenames
;     Definition     (K x 1)-string, one name for each time series
;   Output
;     There is no return value. A menu will appear on the screen.
; ----------------------------------------------------------------------
;   Author        Benkwitz 982801
; ---------------------------------------------------------------------- 
  ;
  ; interpret input variables
  ;
  if (adj==0)  ; no adjustment has been made -> estimate intercept!
    inter=1
  else
    inter=0
  endif
  y0=y[,1:p]                   ; pre sample values
  K=rows(y)                    ; dimension of time series 
  T=cols(y)-p                  ; number of obserations 
  ;
  ;
  {ahat,uhat,shat,ghat}=varunls(y,p,inter)  ; estimation
  ;;
  ;; meta-parameter: (and defaults)
  ;; 
; ahat
  backdefault   = 0
  backmenu      = 0
  backnum       = -1
  backnumtext   = "Back to the last Menu (Type '"+string( "%1.0f", backnum)+"')."
  backtext      = "Back to the last Menu."
  bootci        = 0    ; 0=Bootstrap CI not yet computed. 1=Bootstrap CI computed
  bootcicoverage= 0    ; coverage of the bootstrapci
  bootcielo     = 0
  bootcieup     = 0
  bootcihlo     = 0
  bootcihup     = 0
  bootciirmax   = 0    ; max lead of the bootstrapci
  selectgraph   = 0|0|0; indicates which graphs/ confidence intervals to be plotted
;;;;;;;;;;;;;;;;;;;;;;;; DEFAULT VALUE (.95) 
  coverage      = .9   ; coverage probability
  elo           = 0    ; efron lower percentile limit
  eup           = 0    ; efron upper percentile limit
  exit          = 0    ; 0=stay in ir-analysis, 1=exit ir-analysis
  exitnumtext   = "Exit Impulse Response Analysis (Type '"+string( "%1.0f", backnum)+"')."
  exittext      = "Exit Impulse Response Analysis."
  hlo           = 0    ; hall lower percentile limit
  hup           = 0    ; hall upper percentile limit
  impulse       = 1:K  ; impulse variables
; inter                ; intercept indicator (1=intercept exist in ahat, 0=otherwise)
  irhat         = 0    ; ir-functions
;;;;;;;;;;;;;;;;;;;;;;;; DEFAULT VALUE (12) 
  irmax         = 12    ; maximum lead for ir-analysis
; K                    ; number of endogenous variables (number of equations)
;;;;;;;;;;;;;;;;;;;;;;;; DEFAULT VALUE (100) 
  nodraws       = 100    ; number of bootstrap draws
  response      = 1:K  ; response variables
  string        = ""|""
; uhat
; variablenames
; y0
  yscale        = "sep"
  m  = list( backdefault, backmenu, backnum, backnumtext, backtext, exittext, exitnumtext, coverage, irmax, inter, ahat, bootci, nodraws, elo, eup, hlo, hup, uhat, y0, irhat, yscale, impulse, response, variablenames, selectgraph, exit, K, bootcicoverage, bootciirmax, bootcielo, bootcieup, bootcihlo, bootcihup, string)  
  ;
  ;
  ; parameter for menu contol
  ;
  bootci       = 0
  coverage     = 0
  display      = 0
  impulse      = 0
  main         = 1
  irmax        = 0
  infodisplay  = 0
  response     = 0
  yscale       = 0
  selectgraph  = 0
  enter = list( main, bootci, infodisplay, impulse, response, yscale, selectgraph, display, coverage, irmax)
  ;
  return = list( bootci, display)
  ;
  if (m.irmax>0)
    ;
    ; computing Forecast Error Impulse Responses
    ;
    m.irhat=impres(m.ahat,m.inter,m.irmax)
    ;
  endif
  ;
  do
    switch
      case (enter.main)
        enter.main = 0
        m = iramain(m)
        ;
        switch
          case (m.backmenu==1)
            enter.display = 1
            break
          case (m.backmenu==2)
            enter.selectgraph = 1
            break
          case (m.backmenu==3)
            enter.bootci = 1
            break
          case (m.backmenu==4)
            enter.impulse = 1
            break
          case (m.backmenu==5)
            enter.response = 1
            break
          case (m.backmenu==6)
            enter.yscale = 1
            break
          case (m.backmenu==7)
            enter.coverage = 1
            break
          case (m.backmenu==8)
            enter.irmax = 1
            break
          default
              m.exit = 1
        endsw
      case (enter.irmax)
        enter.irmax = 0
        m = irairmax(m)
        ;
        switch
          case (return.display==1)
            enter.display = 1
            break
          case (return.bootci==1)  
            enter.bootci = 1
            break
          default
            enter.main = 1
        endsw
        ;
        break
      case (enter.infodisplay)
        enter.infodisplay = 0
        m = irainfodisplay(m)
        ;
        enter.main = 1
        ;
        break
      case (enter.coverage)
        enter.coverage = 0
        m = iracoverage(m)
        ;
        switch
          case (return.display==1)
            enter.display = 1
            break
          case (return.bootci==1)  
            enter.bootci = 1
            break
          default
            enter.main = 1
        endsw
        ;
        break
      case (enter.bootci)
        enter.bootci  = 0
        return.bootci = 0
        ;
        switch
          case ((m.coverage<=0)||(m.coverage>=1))
            enter.coverage = 1
            return.bootci = 1
            break
          case (m.irmax<=0)
            enter.irmax = 1
            return.bootci = 1
            break
          default
            ;
            m = irabootci(m)
            ;
            enter.main = 1
        endsw
        ;
        break
      case (enter.impulse)
        enter.impulse = 0
        m = iraimpulse(m)
        ;
        enter.main = 1
        ;
        break
      case (enter.response)
        enter.response = 0
        m = iraresponse(m)
        ;
        enter.main = 1
        ;
        break
      case (enter.yscale)
        enter.yscale = 0
        m = irayscale(m)
        ;
        enter.main = 1
        ;
        break
      case (enter.selectgraph)
        enter.selectgraph = 0
        m = iraselectgraph(m)
        ;
        enter.main = 1
        ;
        break
      case (enter.display)
        enter.display = 0
        switch
          case (m.irmax<=0)
            enter.irmax = 1
            return.display = 1
            break
          case (  ( m.bootcicoverage!=m.coverage )&&( sum(m.selectgraph[2:3])!=0 )  ) 
            m.string[1] = "The coverage probability has changed (From "+string("%2.2f",m.bootcicoverage*100)+"% to "+string("%2.2f",m.coverage*100)+"%)." 
            m.string[2] = "You need to recompute the Bootstrap CI." 
            enter.infodisplay = 1
            break
          case  (  ( m.bootciirmax<m.irmax )&&( sum(m.selectgraph[2:3])!=0 )  )
            m.string[1] = "The Maximum Lead has increased (From "+string("%1.0f",m.bootciirmax)+" to "+string("%1.0f",m.irmax)+")."
            m.string[2] = "You need to recompute the Bootstrap CI." 
            enter.infodisplay = 1
            break
          default
            m.selectgraph[1] = 1
            m.elo = m.bootcielo[1:(m.irmax)+1,]
            m.eup = m.bootcieup[1:(m.irmax)+1,]
            m.hlo = m.bootcihlo[1:(m.irmax)+1,]
            m.hup = m.bootcihup[1:(m.irmax)+1,]
            m = iradisplay(m)
            ;
            enter.main = 1
        endsw
        break
      default
        m.exit = 1      
    endsw
    ;
    ;
    ;
  until (m.exit==1)
  ;
endp
;
proc(out)=vector2string(in)
  out=string("%1.0f", in[1])
  i = 2
  while (i<=rows(in))
    out = out+", "
    out = out+string("%1.0f", in[i])
    i   = i + 1
  endo
endp
;
proc(out)=strvector2string(in)
  out=in[1]
  i = 2
  while (i<=rows(in))
    out = out+", "
    out = out+in[i]
    i   = i + 1
  endo
endp;
;
proc(out)=comparevector( v1, v2)
  error( !(rows(v1)==rows(v2)), "ERROR: both vectors do not have the same length.")
  r=rows(v1)
  out=1
  i = 0
  do 
    i = i + 1
    if (!(v1[i]==v2[i]))
      out = 0
      i   = r 
    endif
  until (i==r)
endp;
;
proc(n)=irairmax(m)
  m.backmenu = 0
  options = "Maximum Lead for Impulse Responses" | m.backnumtext
  leave   = 0
  do
    par=m.irmax|m.backdefault
    par=readvalue( options, par)
    m.irmax    = par[1]
    ;
    switch
      case (par[2]==m.backnum)
        m.backmenu = 1
        leave = 1
        break
      case (m.irmax<0)
        header = "Warning: Invalid Input! Maximum Lead = "+string("%1.2f",m.irmax)+"."
        temp   = selectitem(header, "     Continue", "single")
        break
      default
        ;
        ; computing Forecast Error Impulse Responses
        ;
        m.irhat=impres(m.ahat,m.inter,m.irmax)
        ;
        leave=1
    endsw
    ;
  until (leave==1)
  ;
  n=m 
endp
;
proc(n)=iracoverage(m)
  m.backmenu = 0
  options = "Coverage Probability of two-sided Confidence Intervals" | m.backnumtext
  leave    = 0
  do
    par=m.coverage|m.backdefault
    par=readvalue( options, par)
    m.coverage = par[1]
    ;
    switch
      case (par[2]==m.backnum)
        m.backmenu = 1
        leave = 1
        break
      case ((m.coverage<=0)||(m.coverage>=1))
        header = "Warning: Invalid Input! Coverage = "+string("%1.2f",m.coverage*100)+"%. ("+string("%1.2f",m.coverage)+")"
        temp   = selectitem(header, "     Continue", "single")
        break
      default
        leave = 1
    endsw
    ;
  until (leave==1)
  ;
  n=m 
endp
;
proc(n)=irabootci(m)
  m.backmenu = 0
  string  = "Number of Draws for numerical Approximation of Bootstrap Distribution" 
  do
    stay    = 1                        ; Escape variable
    nodraws = m.nodraws|m.backdefault  
    nodraws = readvalue(string|m.backnumtext,nodraws)
    if (nodraws[2]==m.backnum) 
      m.backmenu = 1
      m.bootci   = 0
    else 
      m.bootci = 1
      m.nodraws=nodraws[1]
      ;
      ; check for invalid input/ or check for to high input, for possible bad numerical approximation
      ;
      if (m.nodraws<2)
        string= "Warning: Invalid Input! You want to do "+string("%1.2f",m.nodraws)+" redraws."
        stay  = 0
      else
        switch
          case (m.nodraws>5000)
            do
              header  = "Warning: The number of draws ("+string("%1.0f",m.nodraws)+") may require to much time!"
              options = "Go back for decreasing the number of draws."|"Don't mind, continue with calculations."
              selection=selectitem( header, options, "single")
            until (sum(selection)==1)
            if (selection[1]==1)
              string= "Your want to do "+string("%1.2f",m.nodraws)+" redraws. This is valid, but requires to much time. New input:"
              stay=0
            endif
            break
          case ((m.coverage * m.nodraws)<200)
            do
              header  = "Warning: The number of draws ("+string("%1.0f",m.nodraws)+") might be too small!"
              options = "Go back for adjusting (increase!) the number of draws."|"Don't mind, continue with calculations."
              selection=selectitem( header, options, "single")
            until (sum(selection)==1)
            if (selection[1]==1)  
              string= "Your want to do "+string("%1.2f",m.nodraws)+" redraws. This might result in bad numerical approximation. New input:"
              stay=0
            endif
        endsw
      endif
    endif
  until (stay)
  ;
  ;
  ;
  if (m.bootci==1)
    ;
    ; computing bootstrap confidence intervals
    ;
    selection=1
    if (m.nodraws>5000)
      do
        header  = "Last Warning: You really want to do "+string("%1.0f",m.nodraws)+" Bootstrap Draws?"
        options = "Yes."|"No."
        selection=selectitem( header, options, "single")
      until (sum(selection)==1)
    endif
    if (selection[1]==1)
      {elo,eup,hlo,hup}=ciirboot(m.ahat,m.uhat,m.y0,m.irmax,m.coverage,m.nodraws)
      m.bootcielo = elo
      m.bootcieup = eup
      m.bootcihlo = hlo
      m.bootcihup = hup
      m.bootcicoverage = m.coverage
      m.bootciirmax = m.irmax
    else
      m.backmenu = 1
      m.bootci   = 0
    endif
  endif
  ;
  n=m 
endp
;
proc(n)=irayscale(m)
  m.backmenu = 0
  scalevalues="sep"|"row"|"all"
  stay=1
  ;
  ; scaling preferences
  ;
  header  = "Which Scaling of the Impulse Response Plots do you want?"
  options = "Individual Scaling for each Plot"|"If Response Variable is the same, identical scaling of Plots."|"Identical Scaling for all Plots"
  do
    scale=selectitem( header, options|m.backtext, "single")
  until (sum(scale)==1)
  scale=maxind(scale)
  if (scale==4)
    m.backmenu = 1
  else
    m.yscale = scalevalues[scale]  
  endif
  n=m 
endp
;
proc(n)=iraimpulse(m)
  m.backmenu = 0
  ;
  ; impulse-variables prefernces
  ;
  header  = "Which Impulse Variables do you want to plot?"
  do
    impulse = selectitem( header, (string("Impulse Variable: ",1:m.K)+m.variablenames)|"All Variables"|m.backtext) 
  until (sum(impulse)>=1)
  if (impulse[rows(impulse)]==1)
    m.backmenu = 1 
  else
    impulse=impulse[1:rows(impulse)-1]
    if (impulse[rows(impulse)]==1)
      m.impulse = 1:m.K
    else
      m.impulse = paf(1:m.K+1,impulse==1)
    endif
  endif
  ;
  n=m 
endp
;
proc(n)=iraresponse(m)
  m.backmenu = 0
  ;
  header   = "Which Response Variables do you want to plot?"
  do
    response=selectitem( header, (string("      Response Variable: ",1:m.K)+m.variablenames)|"All Variables"|m.backtext) 
  until (sum(response)>=1)
  if (response[rows(response)]==1)
    m.backmenu = 1
  else
    response=response[1:rows(response)-1]
    if (response[rows(response)]==1)
      m.response = 1:m.K
    else
      m.response = paf(1:m.K+1,response==1)
    endif
  endif
  ;
  n=m 
endp
;
proc(n)=iraselectgraph(m)
  m.backmenu = 0
  ;
  ; selection of confidence method
  ;
  header    = "Which Confidence Interval(s) do you want to plot?"
  options   = "None"|"Efron's Bootstrap Percentile CI"|"Hall's Bootstrap Percentile CI"|m.backtext
  if (!(m.bootci==1))
    options=options+(""|"  (not yet computed)"|"   (not yet computed)"|"")
  endif
  leave = 0
  do
    do
      selection = selectitem( header, options)
    until (sum(selection)>=1)
    switch
      case ((selection[rows(selection)] == 1)||(m.bootci == 0))
        m.backmenu = 1
        leave = 1
        break
      default 
        m.selectgraph[2] = selection[2]
        m.selectgraph[3] = selection[3]
        leave = 1
    endsw
  until (leave==1)
  ;
  n=m 
endp
;
proc(n)=iramain(m)
  m.backmenu = 0
  ;
  ; main menu
  ;
  header    = "Impulse Response Analysis: Main Menu  ['Setting']"
  switch
    case (sum(m.selectgraph[2:3])==0)
      optci = "None"
      break
    default 
      string = "Efron's Percentile"|"Hall's Percentile"
      optci = strvector2string( string[ paf(1:2,m.selectgraph[2:3]==1) ])
  endsw
  switch
    case (m.bootci==1)
      optbo = "Recompute "
      break
    default
      optbo = "Compute "
  endsw
  switch
    case (m.yscale=="row")
      optsc = "row-wise"
      break
    case (m.yscale=="all")
      optsc = "row- and column-wise"
      break
    default
      optsc = "individual"
  endsw 
  options   = "Plot Forecast Error Impulse Responses" |( "Select Confidence Intervals for Plot ["+optci+"]" )|( optbo+"Bootstrap Confidence Intervals" )|( "Select Impulse Variables  ["+vector2string( (1:m.K)[m.impulse])+"]" )|( "Select Response Variables ["+vector2string( (1:m.K)[m.response])+"]" )|( "Scaling ["+optsc+"]" )|( "Coverage for Confidence Intervals ["+string("%4.2f",m.coverage*100)+"%]" )|( "Maximum lead for Impulse Response Analysis ["+string("%1.0f",m.irmax)+"]" )|m.exittext
  do
    selection = selectitem( header, options, "single")
  until (sum(selection)==1)
  switch
    case (selection[rows(selection)]==1)
      m.exit = 1
      break
    default
      m.backmenu = maxind(selection)
      break
  endsw
  ;
  n=m 
endp
;
proc(n)=iradisplay(m)
  m.backmenu = 0
  ;
  labelir    = "Estimated Forecast Error Impulse Response"
  labelefron = "Bootstrap Confidence Interval: Efron's "+string("%2.1f", m.coverage*100)+"% Percentile Interval"
  labelhall  = "Bootstrap Confidence Interval: Hall's "+string("%2.1f", m.coverage*100)+"% Percentile Interval"
  switch
    case ( comparevector( m.selectgraph, 1|0|0) )
      plotir(m.irhat, "variables", m.variablenames, "labels", labelir, "impulse", m.impulse, "response", m.response, "scale", m.yscale)
      break
    case ( comparevector( m.selectgraph, 1|1|1) )
      plotir(m.irhat, "cb1", m.elo|m.eup, "cb2", m.hlo|m.hup, "variables", m.variablenames, "labels", labelir|labelefron|labelhall, "impulse", m.impulse, "response", m.response, "scale", m.yscale)
      break
    case ( comparevector( m.selectgraph, 1|1|0) )
      plotir(m.irhat, "cb1", m.elo|m.eup, "variables", m.variablenames, "labels", labelir|labelefron, "impulse", m.impulse, "response", m.response, "scale", m.yscale)
      break
    case ( comparevector( m.selectgraph, 1|0|1) )
      plotir(m.irhat, "cb1", m.hlo|m.hup, "variables", m.variablenames, "labels", labelir|labelhall, "impulse", m.impulse, "response", m.response, "scale", m.yscale)
  endsw
  ;
  n=m 
endp;
;
proc(n)=irainfodisplay(m)
  m.backmenu = 0
  selection = selectitem( m.string[1], m.string[2], "single") 
  n=m 
endp;
