proc (y) = isInf (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      countNaN countNotNumber isNaN isNumber
; -----------------------------------------------------------------
;  Keywords      missing values, infinite values
; -----------------------------------------------------------------
;   Macro        isInf
; -----------------------------------------------------------------
;   Description  Determines whether elements of an array are
;                infinity or -infinity (Inf or -Inf).
; -----------------------------------------------------------------
;   Usage        y = isInf (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  y  
;     Definition array with 1 (true, is NaN) or 0 (false)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(0/0, 1/0, -1/0, 1)
;             x ~ isInf (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of _tmp
;	      [1,]   NaN     0 
;	      [2,]   Inf     1 
;	      [3,]  -Inf     1 
;	      [4,]     1     0 
; -----------------------------------------------------------------
;   Author    TTK, 960424
; -----------------------------------------------------------------

  y = abs(x) == Inf
endp

