proc(dy)=itediff(ytt,i);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  tdiff
; ----------------------------------------------------------------------
;   Macro	  itediff
; ----------------------------------------------------------------------
;   Description   calculates the i^th difference of a time series
; ----------------------------------------------------------------------
;   Usage         dy=itediff(ytt,i)
;   Input 
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed (and transposed) 
;                     time series  
;     Parameter   i 
;     Definition     integer 
;   Output
;     Parameter   dy 
;     Definition     matrix, differenced time series
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
   dy=ytt;
  if (i > 0)
    dy=ytt-(zeros(rows(ytt),i)~ytt[,1:cols(ytt)-i]);
  endif;
endp;
