proc(j)=jbgen(di,ord)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  bgen, jagen,
; ----------------------------------------------------------------------
;   Macro	  jbgen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         j = jbgen(di, ord)
;   Input 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;   Output
;     Parameter   j
;     Definition  vector
; ----------------------------------------------------------------------
;   Example       library("multi")
;		  
; ----------------------------------------------------------------------
;   Result     Contents of j      
;        [1,]        0        1        0        0        0 
;        [2,]        0        0        1        0        0 
; ----------------------------------------------------------------------
;   Author        WH, Sperlich 971106
; ---------------------------------------------------------------------- 
j=zeros(di,1) 			// create vector of zeros
if (ord>=1)
  j=j~eye(di)
endif
if (ord>=2)
  j=j~(zeros(di,di*(ord-1)))
endif
endp






