proc () = kerneltest()
; -----------------------------------------------------------------
; Library        kernel
; -----------------------------------------------------------------
;  See_also      cosi epa gau genvub highepa highgau ngau qua repa rqua 
;                rtri rtrian runi symweigh tri trian uni
; -----------------------------------------------------------------
;   Macro        kerneltest
; -----------------------------------------------------------------
;   Description  kerneltest tests all the aforementioned macros
;                of the kernel.lib
; -----------------------------------------------------------------
;   Usage        kerneltest()
; -----------------------------------------------------------------
;   Author       Lijian Yang, 960321   
; -----------------------------------------------------------------

  t=createdisplay(2,7)

  x = aseq(-1, 21, 0.1)  

;testing the cosine kernel *****************
   
  y= cosi(x)
  show(t,1,1,x~y) 

;testing the epanechnikov kernel ***********
   
  y= epa(x)
  show(t,2,1,x~y) 

;testing the gaussian kernel ***************
   
  y= gau(x)
  show(t,1,2,x~y) 

;testing the quartic kernel ****************
   
  y= qua(x)
  show(t,2,2,x~y) 

;testing the triweight kernel **************
   
  y= tri(x)
  show(t,1,3,x~y) 

;testing the triangle kernel ***************
   
  y= trian(x)
  show(t,2,3,x~y) 

;testing the uniform kernel ****************
   
  y= uni(x)
  show(t,1,4,x~y) 

;testing the radial epanechnikov kernel ****
   
  y= repa(x)
  show(t,2,4,x~y) 

;testing the radial quartic kernel *********
   
  y= rqua(x)
  show(t,1,5,x~y) 

;testing the radial triweight kernel *******
   
  y= rtri(x)
  show(t,2,5,x~y) 

;testing the radial triangle kernel ********
   
  y= rtrian(x)
  show(t,1,6,x~y) 

;testing the radial uniform kernel *********
   
  y= runi(x)
  show(t,2,6,x~y) 

;testing the 6th order gaussian kernel *****

 x = aseq(-4, 81, 0.1)  
 y = highgau(x,6) 
 show(t,1,7,x~y)

;testing the 6th order epanechnikov kernel *
  
 x = aseq(-1, 41, 0.05) 
 y = highepa(x,6)
 show(t,2,7,x~y)

;testing the symmetric weights *************
   
  x=(0.1)*(1:4)                                             
  h=x                                                      
  n=10*x+1                                             
  y = symweigh(x, h, n, "qua")  
  
;testing the volume of unit ball ***********
   
  genvub()

endp
