proc(d)=lpdist(x, q, p)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    distance mat2vec
; -----------------------------------------------------------------------
; Macro       lpdist
; -----------------------------------------------------------------------
; Description computes the so-called Lp-distances between the
;             rows of a data matrix. In the case p=1 (absolute
;             metric) or p=2 (euclidean metric) one should
;             favour the function DISTANCE. 
; -----------------------------------------------------------------------
; Usage       d = lpdist(x, q, p) 
; Input
;   Parameter  x
;   Definition n x m  matrix
;   Parameter  q
;   Definition m x 1  matrix of non-negative weights of columns
;   Parameter  p
;   Definition scalar parameter (p>0) of the Lp-metric 
;
; Output
;   Parameter  d
;   Definition n(n-1)/2 x 1 matrix of paired distances between the
;                           n row points (the sequence of distances
;                           is described in AGGLOM)
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate some data
;             x = #(0, 0, 1, 1)~#(0, 1, 0, 1)
;             ; column weights
;             q = #(1, 1)
;             ; apply euclidean metric
;             lpdist (x, q, 2)
; -----------------------------------------------------------------------
; Result    Content of object d
;
;           [1,]        1 
;           [2,]        1 
;           [3,]   1.4142 
;           [4,]   1.4142 
;           [5,]        1 
;           [6,]        1 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  i=rows(x)
  j=cols(x)
  d=matrix((i*i-i)/2)
  l=1
  r=1/p
  do
     k=0
     l=l+1
     do
       k=k+1
       y=0
       n=0
       do
         n=n+1
         y=y+(abs(x[l,n]-x[k,n]))^p
       until(n.=j)  
       m=i*(k-1)-k*(k-1)/2+l-k
       d[m,1]=(trans(y)*q)^r
     until(k.=l-1) 
   until(l.=i)        
endp        