;
proc (fkr1) = sstern1 (sk1) 
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       mcmillan
; -----------------------------------------------------------------
;   Macro         sstern1
; -----------------------------------------------------------------
;   Description   helping procedure for mcmillan
; -----------------------------------------------------------------
;   Author    Sperlich, Mohrmann  970220 
; -----------------------------------------------------------------
  ;kritischen Ausuebungskurs fuer call
	optd=getglobal("optd")
	sig=(optd[1])
	k=(optd[2])
	ic=(optd[3])
	t=(optd[4])
	id=(optd[5])
	q2=(optd[7])
  y = (log(sk1/k) +(ic - 0.5*sig^2)*t)/(sig*sqrt(t))
 bs=sk1*exp((ic-id)*t)*cdfn(y+sig*sqrt(t))-k*exp(-id*t)*cdfn(y)
 fkr1=(bs+(1-exp((ic-id)*t)*cdfn(y+sig*sqrt(t)))*sk1/q2+k-sk1)^2
endp
;
proc (fkr2) = sstern2 (sk2)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       mcmillan
; -----------------------------------------------------------------
;   Macro         sstern2
; -----------------------------------------------------------------
;   Description   helping procedure for mcmillan 
; -----------------------------------------------------------------
;   Author    Feldmann, Sperlich  970220 
; -----------------------------------------------------------------
 ;kritischen Ausuebungskurs fuer put
	optd=getglobal("optd")
	sig=(optd[1])
	k=(optd[2])
	ic=(optd[3])
	t=(optd[4])
	id=(optd[5])
	q1=(optd[6])
   y = (log(sk2/k) +(ic - 0.5*sig^2)*t)/(sig*sqrt(t))
 bs=k*exp(-id*t)*cdfn(-y)-sk2*exp((ic-id)*t)*cdfn(-y-sig*sqrt(t))
 fkr2=(bs+(1-exp((ic-id)*t)*cdfn(y+sig*sqrt(t)))*sk2/q1-k+sk2)^2
endp
;
;********** main program ********************
;
proc()=mcmillan(eopv,sel,task,ingred)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       american, bs1
; -----------------------------------------------------------------
;   Macro         mcmillan
; -----------------------------------------------------------------
;   Description   calculates option prices 
;                 using the MC Millan formula
; -----------------------------------------------------------------
;   Usage         mcmillan(eopv,sel,task,ingred)
;   Input         
;     Parameter   eopv  
;     Definition      scalar , value of the european option
;     Parameter   sel  
;     Definition      2 x 1 vector ,  if sel[1]=1 'call', else 'put' 
;     Parameter   task  
;     Definition      scalar: (=1) - without dividend, (=2) - with
;                             continuously paid dividend, (=3) - 
;                             with a fixed dividend at the end of T,
;                             (=4) - if for exchange rate
;     Parameter   ingred  
;     Definition      6 x 1 vector , stock price, strike price,
;                                    time of expiration, volatility, 
;                                    domain interest rate, dividend
;   Output        
;   
; -----------------------------------------------------------------
;   Example   see american
; -----------------------------------------------------------------
;   Result    option price using MC Millans formula 
; -----------------------------------------------------------------
;   Author    Sperlich, Mohrmann  970220 
; -----------------------------------------------------------------
 s  = ingred[1]
 k  = ingred[2]
 t  = ingred[3]
 sig= ingred[4]
 r  = ingred[5]
 q  = ingred[6]
 id = r
 ic = r-q
 root=(1-(2*ic/sig^2))^2+(8*id/sig^2)/(1-exp(-id*t)) 
 if (sel[1])   ; if call
   ce = eopv
   q2= (1-2*ic/sig^2+ sqrt(root))/2
   ;optimization along s_star  
    optd = sig|k|ic|t|id|0|q2
    putglobal("optd")
    sk1 = nelmin(s,"sstern1",500,1.0e-1) 	
    s1star = sk1.minimum		
    y = (log(s1star/k) +(ic - 0.5*sig^2)*t)/(sig*sqrt(t))
    a2= (1-exp((ic-id)*t)*cdfn(y+sig*sqrt(t)))*s1star/q2
    if (s<s1star)
       ca=ce+a2*(s/s1star)^q2
    else
       ca=s-k
    endif
    opv = ca
    sent=" The Price of Your American Call-Option "
 endif
 if (sel[2])    ; if put
   pe = eopv
   q1= (1-2*ic/sig^2- sqrt(root))/2
   ;optimization along s_starstar 
    optd = sig|k|ic|t|id|q1|0
    putglobal("optd")
    sk2 = nelmin(s,"sstern2",500,1.0e-1)
    s2star = sk2.minimum
    y = (log(s2star/k) +(ic - 0.5*sig^2)*t)/(sig*sqrt(t))
    a1= -(1-exp((ic-id)*t)*cdfn(-y-sig*sqrt(t)))*s2star/q1
    if (s>s2star)
       pa=pe+a1*(s/s2star)^q1
    else
       pa=k-s
    endif
    opv = pa
    sent=" The Price of Your American Put-Option " 
 endif
 ;;;;;;;;;;;;;;;;;;;;;output
  if (task)	
		switch
		case(task==1) ence=" on Given Stock is " 
		break
		case(task==2) ence=" on Given Stock with cont. Dividends is" 
		break
		case(task==3) ence=" on Given Stock with fixed Dividend is" 
		break
		case(task==4) ence=" on Foreign Exchange is" 
		break
		endsw
  endif	
  opv = string("%4.4f",opv)
  lin=("-------------------------------------")
 aus= " "|lin|sent|ence|opv|lin|" "
 aus
endp
