proc(r, rc, fm, chi)=measure (h)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    conting recide kmeans agglom 
; -----------------------------------------------------------------------
; Macro       measure 
; -----------------------------------------------------------------------
; Description computes coefficients of association between two
;             two partitions which are crossed and build up a
;             contingency table 
; -----------------------------------------------------------------------
; Usage        m = measure (h) 
; Input
;   Parameter  h 
;   Definition k x p  contingency table
;
; Output
;   Parameter  m.r
;   Definition Rand's coefficient
;   Parameter  m.rc
;   Definition Rand's coefficient corrected by chance
;   Parameter  m.fm
;   Definition coefficient of Fowlkes and Mallow
;   Parameter  m.chi
;   Definition Chi-square value
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate x
;             x = #(1, 1, 1, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3)
;             ; generate y
;             y = #(2, 2, 2, 3, 1, 1, 3, 3, 3, 3, 3, 2, 2, 3, 2, 2, 1, 1, 1, 2, 1)
;             ; generate contingency table
;             h  = conting(x, y) 
;             ; compute measures
;             measure(h)
; -----------------------------------------------------------------------
; Result      Content of object _tmp.r
; 
;             [1,]  0.81905 
;             Content of object _tmp.rc
;
;             [1,]   0.5767 
;             Content of object _tmp.fm
; 
;             [1,]  0.70778 
;             Content of object _tmp.chi
; 
;             [1,]   26.906 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  I=sum(sum(h,2))
  N=I*(I-1)/2
  hr=sum(trans(h))'
  gr=hr.-1
  rr=hr.*gr./2
  rs=sum(rr)'
  hc=sum(h)'
  gc=hc.-1
  c=hc.*gc./2
  cs=sum(c)'
  g=hr*trans(hc)
  f=g./I
  s=h.-f
  t=s.*s
  u=t./g
  chi=I*sum(sum(u,2))
  g=h.-1
  h=h.*g./2
  hs=sum(sum(h,2))
  r=(N+2*hs-rs-cs)/N
  fm=hs/sqrt(rs*cs)
  rc=(hs-rs*cs/N)/(0.5*(rs+cs)-rs*cs/N)
endp   