proc() = metricstest()
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also     
; -----------------------------------------------------------------
;   Macro        metricstest
; -----------------------------------------------------------------
;   Description  executes some tests for the macros defined
;                in metrics.lib Is invoked by vertest().     
; -----------------------------------------------------------------
;   Usage        metricstest()
;   Input
;   Output
; -----------------------------------------------------------------
;   Example          library("metrics") 
;                    metricstest()
; -----------------------------------------------------------------
;   Result	there should be no error messages. at the end of 
;		metricstest, the line "metrics is ready" should appear 
; -----------------------------------------------------------------
;   Author       akw, 960510
; -----------------------------------------------------------------
       randomize(66666) 

;      testing andrews, select and powell

       n       = 200                           ; sample size 
       ss1     = #(1,0.9)~#(0.9,1)             ; covariance matrix of error terms 
       g       = #(1)                          ; true coefficient of decision equation 
       b       = #(-9, 1)                      ; true intercept and slope of outcome equation 
       u       = gennorm(n, #(0,0), ss1)       ; generate realizations of joint distribution of error terms 
       ss2     = #(1,0.4)~#(0.4,1)             ; covariance matrix of regressors 
       xz      = gennorm(n, #(0,0), ss2)       ; generate realizations of joint distribution of regressors 
       z       = xz[,2]                        ; regressor of decision equation 
       q       = (z*g+u[,1].>=0)               ; generate binary dependent variable of decision equation 
       hd      = 0.1*(max(z) - min(z))         ; bandwidth for dwade procedure 
       d       = dwade(z,q,hd)*(2*sqrt(3)*pi)  ; dwade estimate * scaling factor 
       id      = z*d                           ; estimated first-step index 
       x       = matrix(n)~xz[,1]              ; regressors for outcome equation 
       y       = x*b+u[,2]                     ; dependent variable for outcome equation 
       zz      = paf(y~x~id, q)                ; impose censored sampling 
       y       = zz[,1] 
       x       = zz[,3:(cols(zz)-1)] 
       id      = zz[,cols(zz)] 
       h       =  0.2*(max(id) - min(id))
       hs      = (quantile(id, 0.7))|(0.2*(max(id) - min(id))) ;  bandwidth for select procedure 
        ha     = quantile(id, 0.7)
      {e,f}    = select(x,y,id,hs)
        b      = powell(x,y,id,h)
        z      = sort(id~y~x,1)
        id     = z[,1]
        y      = z[,2]
        x      = z[,3:cols(z)]
        a      = andrews(x,y,id,b,ha)

;      testing tobit

        n       =       500
       k       =       2
       x       =       matrix(n)~aseq(1, n ,0.25)
       s       =       8 
       u       =       s*normal(n)
       b       =       #(-9, 1)
       ystar   =       x*b+u
       y       =       ystar.*(ystar.>=0) 
       tstep   =       tobit(x,y)
       
;      testing heckman

        n      =       500
       s1      =       1 
       s2      =       1 
       s12     =       0.7 
       ss      =       #(s1,s12)~#(s12,s2) 
       ev      =       eigsm(ss) 
       va      =       ev.values 
       ve      =       ev.vectors 
       ll      =       diag(va) 
       ll      =       sqrt(ll) 
       sh      =       ve*ll*ve' 
       u       =       normal(n,2)*sh' 
       z       =       2*normal(n,2) 
       g       =       #(1,2) 
       q       =       (z*g+u[,1].>=0) 
       x       =       matrix(n)~aseq(1, n ,0.25)
       b       =       #(-9, 1)
       y       =       x*b+u[,2]
       y       =       y.*(q.>0) 
       heckit  =       heckman(x,y,z,q) 

;      testing sssm
        n=500 
       sigmaU=#(1,0.5)~#(0.5,1) 
       sigmaX=diag(#(1,1,1,1,1)) 
       gamma1=#(1,1,1,1) 
       gamma2=#(1,1,-1,-1) 
       v1=#(1,1,1,1,0) 
       v2=#(0,1,1,1,1) 
       U=gennorm(n,#(0,0),sigmaU) 
       X=gennorm(n,#(0,0,0,0,0),sigmaX) 
       xselec=(X[,2:5]*gamma2)+U[,2] 
       indexSelec=( xselec.>=0) 
       Yall=exp(X[,1:4]*gamma1+U[,1]) 
       Y=Yall.*indexSelec 
       nameX="x1"|"x2"|"x3"|"x4"|"x5" 
       rsssm=sssm(Y,X,nameX,0,v1,v2) 
       
;      testing dpls

;coefficients 
b1=0.3 
c1=0.6 
randomize(13409) 
s=500 
n1=normal(s+1) 
n1lag=n1[1:s,] 
n1=n1[2:rows(n1),] 
;inner model 
n2=b1*n1+c1*n1lag+normal(rows(n1))/5 
n=n1 ~ n2 
nn=n./sqrt(var(n)) 
;loadings matrix 
p=( 1 | 2 | 3 | 4 | 0 | 0 | 0) ~ (0 | 0 | 0| 0 | 5 | 6 | 7) 
y=nn*p'+normal(rows(n),rows(p))/8 
d=(0 | 1) ~ (0 | 0) 
dl=(0 | 1) ~ (0 | 0) 
w=(1 | 1 | 1 | 1 | 0 | 0 | 0) ~ (0 | 0 | 0 | 0 | 1 | 1 | 1 ) 
{wg,b,sk,skl,lk,iter}=dpls(w,d,w,dl,y,3) 
{red,redm}=redun(b,sk,lk,skl,y) 
  ;
 ; for    dwade, adeind, adeslp
 ; 
 ;        
  n = 200 
  randomize(123456)
  x   = normal(n,3)
  z   = 0.2*x[,1] - 0.7*x[,2] + x[,3]
  eps = normal(n,1) * sqrt(0.5)
  y   = 2 * z^3 + eps
  h   = 0.3
  d   = dwade(x,y,h)
  d   = 0.2
  m   = 5
  {delta,dvar1} = adeind(x,y,d,m)
  {delta,dvar2} = adeslp(x,y,d,m)

 ;
 ; for    adedis
 ; 
    randomize(10243)
    z=(uniform(100).>0.5)~(uniform(100).<0.5)
    n=rows(z)
    x=normal(100)~normal(100)
    y=z[,1]+0.5*z[,2]+2*x[,1]+4*x[,2]+normal(100)
    h = 0.2*(max(x)-min(x))'   
    hfac = 1.0
    c0=0.2
    c1=0.8
    {d,a}=adedis(z,x,y,h,hfac,c0,c1)

 ;        
 ; for    HH-test
 ;                                              
  x = read("kyphosis.dat") 
  y = x[,4]                           
  x = x[,1:3]
  x = matrix(rows(x))~x       
  h = 2       
  myfit=glmest("bilo",x,y)
  eta=x*myfit.b
  mu=1./(1+exp(-eta))	
  {t,p} = hhtest(eta,y,mu,h,0.05,1)           

 ;        
 ; for    polychotom HH-test
 ;                                              
  n = 100
  b = (1|2)~(-1|0)~(1|1)
  x = normal(n,rows(b))
  y = genmultlo(x,b)
  ml = glmmultlo(x,y)
  vhat =  x*ml.b
  y1   =  y.=1
  y2   =  y.=2
  y3   =  y.=3
  y    =  y1~y2~y3
  c1   =  cols(vhat)
  h    =  matrix(c1)' 
  yhat =  ml.mu
  {t,p}= hhmult(vhat,y,yhat,h)

 ;        
 ; for    sliced inverse regression
 ;          
  x = normal (300, 3)
  b = #(1, 0 ,1)
  y = sin (x*b) + normal(300)
  b = sir (x, y, -20)

;
; testing panel macros
;

	z=read("earnings")
	z1 = z[,1:2]~log(z[,3])~z[,4]~(z[,4]^2)
	{output,siga,sige}=panfix(z1,2)
	panhaus(z1,siga,sige,2)
	panrand(z1,siga,sige,0)     
	z2=pansort(z)
	panstats(z)
	panunit(z,1,0,1)
	y=pantime(z)

	z=read("dynpanel.dat")
	{output,b}=pandyn(z,1,0)
	pandyn2(z,1,0,b)
	panunit(z,4,0,1)

;
; testing quantile regression macros
;

	     randomize(101)
             x = uniform(100,3)
             y = x[,1] + 2*x[,2] - x[,3] + normal(100)
             z = rqfit(x,y)
	     rrstest(x[,1:2], x[,3], y)

"metrics is ready"
endp
