proc(data)=missings(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata missingsmethod
; -----------------------------------------------------------------------
; Macro        missings
; -----------------------------------------------------------------------
; Description  offers three possibilities to the user to handle the missing
;              values in the data set. It is possible to exclude the 
;              variable, the case or to replace the missing with a specified
;              value.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  text=" "
  if((sum(data.rowmissing))&&(sum(data.colmissing)))
    datah=paf(data.x,data.rowmissing)   
    i=0 
    nan=0 
    while(i<cols(datah))
      i=i+1
      c=countNaN(datah[,i])
      nan=nan|c  
    endo
    data.nan=nan[2:rows(nan)]
  else
    text="(no cases and/or no variables left)"
  endif
  colv=string("%10.10s",data.colname )
  selheadr="Reset?"+text
  selitemr="Yes"
  selr=selectitem(selheadr,selitemr)
  if(selr[1])
    data.colmissing=matrix(cols(data))
    data.rowmissing=matrix(rows(data))
    datah=paf(data.x,data.rowmissing)
    i=0
    nan=0
    while(i<cols(datah))
      i=i+1
      c=countNaN(datah[,i])
      nan=nan|c  
    endo
    data.nan=nan[2:rows(nan)]  
    endif
  deletestr=string(" ",1:rows(data.colname))
  if((sum(1-data.colvar)==0)&&(sum(1-data.colmissing)==0)) 
  ;all variables included
    deletestr=string(" included",1:rows(data.colname)) 
  else                                
  ;some variables excluded
    selk=paf(1:rows(data.colname),(data.colvar==0||data.colmissing==0)) 
    deletestr[selk]=string(" excluded",data.colvar[selk])
    selk1=paf(1:rows(data.colname),(data.colvar==1&&data.colmissing==1)) 
    deletestr[selk1]=string(" included",data.colvar[selk1]) 
  endif
  selhead="Choose variables"
  selitem=colv+deletestr+string(" %.0f",data.nan)+" NaNs"   
  sel=selectitemlist(selhead,selitem,15)
  if(sum(sel))
    sel2 = sel[1:rows(sel)]
    sel2 = paf(1:rows(sel2), sel2)
    i=0
    while (i<rows(sel2)) ;loop over variables
      i   = i+1
      sel = sel2[i]  
      data = missingsmethod(data,sel)
      ;entsprechende ausgewaehlte Variablen als einzelne 
      ; Vektoren in Methode
    endo
  endif
endp