proc()=modelss(typ,ytt,header,outp,y)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti 
; -----------------------------------------------------------------
;   Macro        modelss
; -----------------------------------------------------------------
;   Description  general analysis for the Subset VAR Model, called
;                by the quantlet domulti
; -----------------------------------------------------------------
;   Usage        modelss(typ,ytt,header,outp,y)  
;   Input
;     Parameter   typ  
;     Definition      integer, model type (2 for Subset VAR)
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed time series  
;     Parameter   header
;     Definition      list of 7 objects:   natlog,diff,origyear,
;                     periodicity,origperiod,name,exclude
;     Parameter   outp
;     Definition      integer, (1=output to file, 0 = no output)
;     Parameter   y 
;     Definition      k x n matrix, the original time series
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; -----------------------------------------------------------------
  di=rows(ytt)
  diff=header[2]
  infotran=(1:di) ~ (header.diff*2-1) ~ (header.natlog*2-1)
  sel="Order"|"Beginning of sample"|"End of sample"
  sel=sel | "Criterion (1=AIC,2=HQ,3=SC,4=none)"
  sel=sel | "Set own zero restrictions (0=no,1=yes)" 
  r=readvalue(sel,2|3|cols(ytt)|1|0)
  ord=r[1]
  tb=r[2]
  te=r[3]
  t=te-tb+1
  error(tb-ord<1, "Check beginning of sample!")
  cri=r[4]
  ozr=r[5]
  if (ozr==0)
      obr = ones(di,ord*di+1)
  else
      obr = ones(di,ord*di+1)
      item1=" 0"
      j=1
      while(j<=ord)
        item1=item1|string(" %1.0f",j)
        j=j+1
      endo
      item1=item1|" Show current own restrictions "
      item2=" 1"
      j=2
      while(j<=di)
        item2=item2|string(" %1.0f",j)
        j=j+1
      endo
      head1 = " Select parameter matrix (0=intercept,...)"
      head2 = " Select row index"
      head3 = " Select column index"
      back=0
      while (back==0)
        sel=selectitem(head1,item1,"single")'*(1:rows(item1))
        if (sel==0)
           back=1
        else
          if (sel==rows(item1))
            dummy = createdisplay(ord+1,1)
            str=string("  %1.0f",obr[,1])
            str="  Intercept (1 = no restriction) "|" "|str
            show(dummy,1,1,str)
            j=1
            while(j<=ord)
             str=string("  %1.0f",obr[,(j-1)*di+2])
             i=3
             while(i<=di+1)
                str=str+(string("  %1.0f",obr[,(j-1)*di+i]))
                i=i+1
             endo
             str=string("   A%1.0f",j)|" "|str
             show(dummy,j+1,1,str)
             j=j+1
            endo  
          else
            pm = sel
            if (pm==1)
               ri=selectitem(head2,item2,"single")'*(1:rows(item2))
               obr[ri,1]=0
            else
               ri=selectitem(head2,item2,"single")'*(1:rows(item2))
               ci=selectitem(head3,item2,"single")'*(1:rows(item2))
               obr[ri,(pm-2)*di+ci+1]=0
            endif
          endif 
         endif
       endo
  endif
  covu=covres(ord,di,tb,te,0,typ,ytt);
  ok=covcheck(covu);
  if (ok==1)
    kom=kommumat(di,di*ord+1);
    r=rgenss(ord,di,t,tb,te,0,cri,obr,ozr,typ,ytt);
    jota=jbgen(di,ord);
    icovu=inv(covu);
    zz=zmulz(ord,di,tb,te,0,0,typ,ytt);
    b2=coeffss(r,icovu,zz,ord,di,tb,te,0,ytt);
    u=residuen(b2,ord,di,0,tb,te,ytt);
    covu=u*u'/t;
    icovu2=inv(covu);
    sfb2=sfvonbss(r,icovu2,zz/t,di,ord,t);
    headline=" Menu: Results of Subset VAR estimation" 
    items= " Coefficients (standard errors)" | " Coefficients (t-ratios)"  
    items = items | " Covariance Matrix of Residuals" | " Residual Analysis"
    items = items | " Test for structural break" | " Forecasting" 
    items = items | " Quit to main menu"
    do
     is=selectitem(headline, items,"single") 
    switch
    case (is[1]) 
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b2[,1])+string(" (%5.2f)",sfb2[,1])
        str="  Intercept  (standard errors in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Subset VAR Coefficients (standard errors)"
            str
        endif
        j=1
        while(j<=ord)
        str=string("  %5.2f",b2[,(j-1)*di+2])+string(" (%5.2f)",sfb2[,(j-1)*di+2])
        i=3
    while(i<=di+1)
        str=str+(string("  %5.2f",b2[,(j-1)*di+i]))
        str=str+(string(" (%5.2f)",sfb2[,(j-1)*di+i]))
        i=i+1
    endo
    str=string("   A%1.0f",j)|" "|str
    show(dummy,j+1,1,str)
    if (outp==1)
        " "
        str
    endif
    j=j+1
    endo break
;  
    case (is[2]) 
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b2[,1])+string(" (%5.2f)",b2[,1]./sfb2[,1])
        str="  Intercept  (t-ratios in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Subset VAR Coefficients (t-ratios)"
            str
        endif
      j=1
      while(j<=ord)
        str=string("  %5.2f",b2[,(j-1)*di+2])+string(" (%5.2f)",b2[,(j-1)*di+2]./sfb2[,(j-1)*di+2])
        i=3
        while(i<=di+1)
          str=str+(string("  %5.2f",b2[,(j-1)*di+i]))
          str=str+(string(" (%5.2f)",b2[,(j-1)*di+i]./sfb2[,(j-1)*di+i]))
          i=i+1
        endo
        str=string("   A%1.0f",j)|" "|str
        show(dummy,j+1,1,str)
        if (outp==1)
            " "
            str
        endif
        j=j+1
    endo break
;
    case (is[3])
      dummy=createdisplay(1,1)
      str=string("%5.2e",covu[,1])
      i=2
      while(i<=di)
          str=str+string("  %5.2e",covu[,i])
          i=i+1
      endo
      str1 = "Covariance Matrix of Residuals"
      str2 = "Determinant = " + string("  %5.2f",det(covu))
      str = str1 | str2 | " " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Subset VAR Model"
        str
      endif
      break
    case (is[4])
;
; Residual analysis   
; -----------------------------------------------------------------------------
  noquit = 1
  noback=1
  while (noquit && noback)
    head = " Menu: Residual Analysis of Subset VAR estimation"
    item = " Individual Residual Series Analysis "
    item = item|" Multivariate Portmanteau statistic"
    item = item | " Multivariate normality tests"
    item = item|" Back"
    stat = selectitem(head,item,"single")
      
    switch
    case (stat[1])
    head = " Select time series "
    item = string(" ",1:di)+header.name+string("                ",1:di)
    item = substr(item,1,16)
    logstr = string("   ",1:di)
    item = item |" Back"
    tseries = selectitem(head,item,"single")'*(1:rows(item))
    if (tseries==0||tseries==rows(item))
      noquit = 0
      noback = 0
    endif
    while (noback)
    head = " Select desired transformation "
    item = " Residuals" | " Absolute residuals" | " Squared residuals" |" Back"
    tr = selectitem(head,item,"single")'*(1:rows(item))
    switch
    case (tr==1)
        r = u'
        item2= " residuals" 
    case (tr==2)
        r = abs(u)'
        item2= " absolute residuals" 
    case (tr==3)
        r = (u.^2)'
        item2= " squared residuals"  
    case (tr==0 || tr == rows(item))
        noback=0
        break 
    endsw
    while (noback)
      head = header.name[tseries]
      item = (" Plot of"+item2)|(" ACF of"+item2)
      item = item|(" PACF of"+item2)
      item = item|(" Periodogram of"+item2)
      item = item|" Spectral density estimation"
      item = item|" Back to results menu"
      resid = selectitem(head,item,"single")
      switch
        case (resid[1])
        header[tseries]
          dummy=timeplot(r[,tseries],400,header)
          break
        case (resid[2])
          dummy=acfplot(r[,tseries])
          if (outp==1)
              "ACF of"+item2+" of "+head
              acf(r[,tseries]) 
          endif
          break
        case (resid[3])
          dummy=pacfplot(r[,tseries])
          if (outp==1)
              "PACF of"+item2+" of "+head
              pacf(r[,tseries],30) 
          endif
          break
        case (resid[4])
          pg = pgram(r[,tseries])
          if (outp==1)
              "Periodogram of"+item2+" of "+head
              pg 
          endif
          break
        case (resid[5]) 
          sp = spec(r[,tseries])
          if (outp==1)
              "Spectral density estimate of"+item2+" of "+head
              sp 
          endif
          break       
        case (resid[6])
          noback = 0
      endsw
      endo
    endo
    dummy  = 0
    break
    case (stat[2])      
          h=readvalue("Up to which lag should be tested?", 10)
          dummy=portmant(b2,0,tb,te,t,di,ord,0,h,di*di*(h-ord),typ,ytt,outp)
    case (stat[3])      
          dummy=normalt(t,di,ord,covu,u,outp)
    case (stat[4])
          noback=0
    endsw
    endo
  break
;
; test for structural breaks
;
  case (is[5])
    covb=kom*r*inv(r'*(kron(icovu,zz))*r)*r'*kom'
    dummy=strucbru(b2,covb,di,ord,0,tb,te,t,covu,typ,ytt,outp)
    break
;
;  Forecasting
;  -----------------------------------------------------------------------
  case(is[6])
     covb=kom*r*inv(r'*kron(icovu,zz)*r)*r'*kom'
     if (sum(header.diff)>0)
          head="Forecasting..."
          item="variables"
          item=item|"undifferenced variables"   
          choice=selectitem(head,item,"single")
      if (choice[1]==1)
       forecast(b2,covb,covu,ord,0,tb,te,ytt,typ,header,outp)
      else 
       forec2(b2,covb,covu,ord,0,tb,te,y,ytt,typ,infotran,header,outp)
      endif
     else
      forecast(b2,covb,covu,ord,0,tb,te,ytt,typ,header,outp)
     endif
    break
  endsw
  until (is[rows(is)])
  noquit=0
dummy=0
endif  
endp
