proc()=nninfo(disp, netid, dec, opt, err, ran, res)               
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        nninfo
; -----------------------------------------------------------------------
; Description  shows some information about the actual network
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  switch
  case (opt==1)               
    optstr = "Optim  : Annealing        " 
    break              
  case (opt==2)               
    optstr = "Optim  : QApprox          "  
    break  
  default  
    optstr = "Optim  : Stochastic       "         
  endsw
  optstr = optstr + string ("Restart: %f", res)  
  switch
  case (err==1)            
    taskstr="Error  : Classification - Maximum likelihood"
    break
  default            
    taskstr="Error  : Regression     - Least squares"             
  endsw
  paramstr = string ("Decay  : %9.5f        ", dec)               
  if (ran<0)
    paramstr = paramstr+string ("Rand   : N(0,%.2f)", abs(ran))
  else
    paramstr = paramstr+string ("Rand   : U(%.2f,%.2f)", -ran, ran)
  endif
  show (disp, 1, 1, netid|taskstr|optstr|paramstr)
endp               
