proc()=nnrsave(net, name)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     nnrnet ann nnrpredict nnrload
; -----------------------------------------------------------------------
; Macro        nnrsave
; -----------------------------------------------------------------------
; Description  saves a network in different names
; -----------------------------------------------------------------------
; Usage        nnrsave(net, name)
; Input
;   Parameter  net
;   Definition composed object from nnrnet
;   Parameter  name
;   Definition name of a file (without extension)
; Output
; -----------------------------------------------------------------------
; Example     x = read("kredit1")
;             t = read("tkredit")
;             y = x[,1]
;             x = x[,2:21]
;             x = (x-min(x))./(max(x)-min(x))
;             net = nnrnet (x, y, matrix(rows(x)), 10)
;             nnrsave (net, "nnkred")
; -----------------------------------------------------------------------
; Result      runs a neural network with 10 hidden units for the kredit 
;             data of Fahrmeier and Hammerle and computes the predicted
;             values and saves it in filesnnkred.xxx
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 970603
; -----------------------------------------------------------------------
  write (net.n|net.decay|net.entropy|net.softmax|net.value, name+ ".nng")
  write (net.nunits, name + ".nnn")
  write (net.nsunits, name + ".nnu")
  write (net.nconn, name + ".nnc")
  write (net.conn, name + ".nno")
  write (net.wts, name + ".nnw")
endp