proc(output)=outputbs(MultipR,Rsquare,Fvalue,FPvalue,colname,betain,Voutt,Vout,k,Fout,dfM,dfR)
; -----------------------------------------------------------------------
; Library stats     
; -----------------------------------------------------------------------
; See_also doista outputfs2 outputpar outputstep outputanova    
; -----------------------------------------------------------------------
; Macro        outputbs
; -----------------------------------------------------------------------
; Description  creates the parameter output for linregbs
; -----------------------------------------------------------------------
; Notes        to be used only in context with the linear regression macros
;              or in context with "doista"
; -----------------------------------------------------------------------
  firstline="Backward Elimination"
  secondline="-------------------------------"
  foutstr=string("%4.2f",Fout)
  out=cdff(Fout,dfM,dfR)
  outstr=string("%3.2f",out)
  thirdline="F-to-remove "+foutstr
  fourthline="probability of F-to-remove "+outstr
  fifthline="Step  Multiple R      R^2        F        SigF        Variable(s)"
  stepstr=string("%2.0f ",1:k)
  MultipRstr=string("%10.4f  ",MultipR)
  Rstr=string("%11.4f  ",Rsquare)
  Fvalstr=string("%9.3f ", Fvalue)
  FPvalstr=+string("%8.3f    ", FPvalue)
  ;colname=string("%10.10s",colname) 
  stepoutstr=string("Step Number %2.0f",max(k))
  if (rows(Voutt)>1)
    Voutt=Voutt[2:rows(Voutt)]  
    variablestr="      none"|colname[Voutt] 
    variableoutstr=colname[Voutt[rows(Voutt)]] 
    seventhline="Variable removed at "+stepoutstr+" = "+variableoutstr 
 else
    variablestr="      none"
    seventhline="No variable removed"  
  endif
  Outstr=string("Out: %s",variablestr) 
  betainstr=string("%3.3f",betain)
  sixthline=stepstr+MultipRstr+Rstr+Fvalstr+FPvalstr+Outstr
  ;stepoutstr=string("Step Number %2.0f",max(k))
  output=firstline|secondline|thirdline|fourthline|""|fifthline|sixthline|""|seventhline
endp
