proc(y) = pacf(x, k)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  acf, fft, invfft
; ----------------------------------------------------------------------
;   Macro	  pacf
; ----------------------------------------------------------------------
;   Description   computes the partial autocorrelation function 
; ----------------------------------------------------------------------
;   Usage         y = pacf(x,k)
;   Input 
;     Parameter   x 
;     Definition  vector
;     Parameter   k
;     Definition  positive integer < 100
;   Output
;     Parameter   y
;     Definition  vector
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=normal(100)
;		  a2=pacf(x,20)
;                 a2[1:5]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp  
;                 [1,] -0.15902 
;                 [2,] -0.15022 
;                 [3,] 0.2644 
;                 [4,] 0.057189 
;                 [5,] -0.12492 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 960605
; ----------------------------------------------------------------------
  p=1                   ; initialize corr matrix
  incr=1                ; initialize increment vector
  a=acf(x)              ; compute autocorrelations
  y=matrix(k).*a[2]     ; initialize pacf-vector  
  i=2
  while(i<=k)
      incr=a[i]|incr
      p=(p~incr[1:rows(incr)-1])|incr' ; denominator matrix
      pn=p[,1:cols(p)-1]~a[2:i+1]      ; nominator matrix
      y[i]=det(pn)/det(p)              ; Cramer's rule
      i=i+1
  endo  
endp           
