proc()=parallel(data)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     parallelrech doista grpcp gruppenvariable istagraphic
;              showd 
; -----------------------------------------------------------------------
; Macro        parallel
; -----------------------------------------------------------------------
; Description  shows parallel coordinate plots for the principal components 
;              of the selected variables. The number of gridpoints can be
;              chosen be the user and one or more group variables 
;              (disctrete type) can be selected.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  dcoltype=data.coltype
  ;for group variable only discrete type 
  ;selvar=(1-data.colvar)&&(1-data.coltype)
  coltype=matrix(rows(data.coltype))
  ;for variable selection both types are allowed
   selvar=choosevariable(data,coltype)
  if(sum(selvar).>0)
    {r,c,l,d,titl}=gruppenvariable(data, "parallelrech",selvar,dcoltype)
    showd(r,c,l,d,titl) 
  endif
endp