proc(notok)=plmtest()
; -----------------------------------------------------------------
; Library	plm
; -----------------------------------------------------------------
;  See_also	plmk,plmp
; -----------------------------------------------------------------
;   Macro	plmtest
; -----------------------------------------------------------------
;   Description  plmtest verifies the PLM macros.
; -----------------------------------------------------------------
;   Link         ../tutorials/plmlib.html Tutorial: PLM in XploRe 
; -----------------------------------------------------------------
;   Usage	 notok = plmtest()
;   Input
;     Parameter
;     Definition	none
;   Output
;     Parameter   notok
;     Definition	'0' if test was o.k., '1' otherwise
; -----------------------------------------------------------------
;   Example   library("plm")
;	      plmtest()
; -----------------------------------------------------------------
;   Result    Content of object notok
;	      [1,]     0
; -----------------------------------------------------------------
;   Author   Hua Liang, 970619
; -----------------------------------------------------------------
randomize(0)
  n = 100 
     sig=0*matrix(3,3) 
     sig[,1]=#(0.81,0.1,0.2) 
     sig[,2]=#(0.1,2.25,0.1) 
     sig[,3]=#(0.2,0.1,1) 
     x =normal(n,3)*sig 
     t =sort(uniform(n)) 
     beta0=#(1.2, 1.3, 1.4) 
     y =x*beta0+t^3+0.01*normal(n) 
      m =2 
      mn=5 
     sf1=plmp(x,t,y,m,mn) 
      h=0.5
     sf2=plmk(x,t,y,h)
   crit1=sum(abs(sf2.hbeta-sf1.hbeta))./sum(abs(beta0))
    notok=(crit1>0.5)
endp
