proc()=plotbox(inX, inFactor)
; ---------------------------------------------------------------------
; Library     plot
; ---------------------------------------------------------------------
; See_also    plotdot, dispbox
; ---------------------------------------------------------------------
; Macro       plotbox
; ---------------------------------------------------------------------
; Description High level routine for boxplots.
; ---------------------------------------------------------------------
; Usage       plotbox(inX {,inFactor})
; Input       
; Parameter   inX
; Definition  n x 1 Vector (continuous data)
; Parameter   inFactor
; Definition  n x 1 Vector (discrete) specifying groups within inX
; Output      
; ---------------------------------------------------------------------
; Notes        Generates a boxplot with median line and upper and lower 
;              edge of the box being the upper and lower quartile.
;
;              The whiskers designate the farest non-outliers above resp.
;              below the box.
;
;              Outliers are all data at least 1.5 * (height of box) away
;              from the upper resp. lower edge of the box. Outliers are 
;              plotted as circles.
;
;              If this distance exceeds 3 * (height of box), a star symbol
;              is used ("gross outlier")
;
;              Requires the library "stats" to be present.
; ---------------------------------------------------------------------
; Example      library("graphic")
;              library("plot")
;              library("stats")
;              x = normal(4000)
;              theFactor = string("one", 1:1000) | string("two", 1:1000)
;              theFactor = theFactor | string("three", 1:1000) | string("four", 1:1000)
;              plotbox(x, theFactor) 
; ---------------------------------------------------------------------
; Result       Four boxplots in one display.
; ---------------------------------------------------------------------
; Keywords     high level graphics, boxplot
; ---------------------------------------------------------------------
; Author      Stephan R. W. Lauer, 990302
; ---------------------------------------------------------------------

// The main task here is to generate the labels for the different groups.
// All other work is done within dispbox.

   if (exist("inFactor") <> 1 && exist("inFactor") <> 2)   // not numeric, not text
      bp = dispbox(inX)
      boxplot = createdisplay(1, 1)  // it would be possible to create the
                                     // display *before* this 'if' and use
                                     // it in both branches, but this way
                                     // it is created 'just in time' :-)
      show(boxplot, 1, 1, bp)
   else 
      // create labels for the groups
 
      theGroups = discrete(inFactor)
      theNumberOfGroups = rows(theGroups)

      // locate the labels centered under the plots, vertical distance
      // is 10% of the spread of the data

      theY = min(inX) - 0.10 .* (max(inX) - min(inX))
      theY2 = min(inX) - 0.15 .* (max(inX) - min(inX))

      // let's see if the factor given is numeric or a string variable
      isNumeric = (exist(theGroups) == 1)
     

      // some inits
      theLabels = ( 0 ~ theY ) | ( 0 ~ theY2) // do this to ensure that the text labels
                                              // at the bottom are displayed properly
      theStrings = "Hallo" | "Hallo" // dummy string - empty string crashes
      
      theStringLocations = -1 | -1   // don't show dummy string
      count = 1
      if (isNumeric)
           while (count <= theNumberOfGroups)
                 theLabels = theLabels | ( (count - 1) * 1.5 + 0.5 ~ theY)
                 theStrings = theStrings | string("%1.0f", theGroups[count])
                 theStringLocations = theStringLocations | 0 // centered
           count = count + 1
           endo
      else
           while (count <= theNumberOfGroups)
                 theLabels = theLabels | ( (count - 1) * 1.5 + 0.5 ~ theY)
                 theStrings = theStrings | theGroups[count]
                 theStringLocations = theStringLocations | 0 // centered
           count = count + 1
           endo
      endif // isNumeric

      // now attach the strings to the points
      setmaskt(theLabels, theStrings, 0, theStringLocations, 16) // black, ..., size 16
      // hide points
      setmaskp(theLabels, 0, 0, 8)

      // now create the boxplot itself and show the results

      bp = dispbox(inX, inFactor)
      boxplot = createdisplay(1, 1)
      show(boxplot, 1, 1, bp, theLabels)
   endif

 
endp