proc () =plotscml(data, names)
; -----------------------------------------------------------------
; Library        plot
; -----------------------------------------------------------------
;  See_also      plotscm
; -----------------------------------------------------------------
;   Macro        plotscml
; -----------------------------------------------------------------
;   Description  Plots a scatterplotmatrix with common axes 
;                where all plots are linked.
; -----------------------------------------------------------------
;   Usage         plotscml (data{, varnames})
;   Input
;     Parameter  data 
;     Definition vector with p columns
;     Parameter  varname 
;     Definition text vector with p columns
;		 ( variable names are expected)
; -----------------------------------------------------------------
;   Example   library("plot")
;    setsize(600, 600)
;    x=read("bank2.dat")
;    names="length"~"left"~"right"~"bottom"~"top"~"diag"
;    plotscml(x, names)
;    setgopt(d, 1, 1, "ymajor", 1)
;    setgopt(d, 2, 1, "ymajor", 1)
;    setgopt(d, 3, 1, "ymajor", 1)
;    setgopt(d, 6, 1, "ymajor", 1)
;    setgopt(d, 7, 2, "xmajor", 1)
;    setgopt(d, 7, 3, "xmajor", 1)
;    setgopt(d, 7, 4, "xmajor", 1)
;    setgopt(d, 7, 7, "xmajor", 1)
; -----------------------------------------------------------------
;   Result    
;		A display with pxp windows is created.
; -----------------------------------------------------------------
; Keywords    high level graphics, scatterplot matrix
; -----------------------------------------------------------------------
;   Author    SwS 970418, Sigbert Klinke 990521
; -----------------------------------------------------------------
  c=cols(data)
  if (c>8)
    error(c>8, "Too many columns for a scatterplotmatrix!")
  endif
  d=createdisplay(c+1, c+1)
  setfractions(d, matrix(c)|0.3, 0.3|matrix(c))
  i=0
  while (i<c)
    i=i+1
    if (exist(names))
      if (cols(names)==c)
        show(d, i, i+1, names[,i])	
      else
        show(d, i, i+1, string("%.0f. Variable", i))	
      endif
    else
      show(d, i, i+1, string("%.0f. Variable", i))
    endif
  endo
  i=0
  while (i<c)
    i=i+1
    j=0
    while (j<c)
      j=j+1
      if (i!=j)
        xx=data[,i]~data[,j]
        setmaskp(xx, 4, 3, 4)
        show(d, j, i+1, xx)
        setgopt(d, j, i+1, "xoffset", 0|0)
        setgopt(d, j, i+1, "yoffset", 0|0)
        if (getenv("os")=="unix")
          setmode(d, j, i+1, 1)
        endif
      endif
    endo
  endo
  i=0
  while (i<c)
    i=i+1
    xx=data[,i]~matrix(rows(data))
    setmaskp(xx, 0, 0, 0)
    show(d, cols(data)+1, i+1, xx)
    setgopt(d, cols(data)+1, i+1, "xoffset", 0|0, "xlabel", " ")
    setgopt(d, cols(data)+1, i+1, "yoffset", 0|80)
  endo
  i=0
  while (i<c)
    i=i+1
    xx=matrix(rows(data))~data[,i]
    setmaskp(xx, 0, 0, 0)
    show(d, i, 1, xx)
    setgopt(d, i, 1, "yoffset", 0|0)
    setgopt(d, i, 1, "xoffset", 80|0, "ylabel", " ")
  endo
  i=0
  while (i<c)
    i=i+1
    j=1
    while (j<c+1)
      j=j+1
      k=0
      while (k<c)
        k=k+1
        l=1
        while (l<c+1)
          l=l+1
          if ( (!((i==k)&&(j==l))) && (i!=j-1) && (k!=l-1) )
            link(d, i, j, d, k, l)
          endif
        endo
      endo
    endo
  endo	
endp

