proc(b)=powell(x,y,id,h)
;------------------------------------------------------------------------
; Library	metrics
;------------------------------------------------------------------------
; See_also	heckman  select andrews	sssm gennorm dwade
;------------------------------------------------------------------------
; Macro		powell
;------------------------------------------------------------------------
; Description   powell calculates the semiparametric estimator proposed 
;		by Powell (1987) of the slope coefficients of the outcome 
;		equation in a sample selection model.		
; ----------------------------------------------------------------------- 
; Usage		b =  powell(x,y,id,h)                 
;------------------------------------------------------------------------
; Input                                                                     
; Parameter	x  
; Definition		n x M  regressor matrix. WARNING: x may not contain a vector of ones!
; Parameter	id  
; Definition		n x 1  vector containing the estimated index of the first-step selection equation.
; Parameter	y
; Definition		n x 1  matrix containing n observ. of the dependent variable                                      
; Parameter	h     
; Definition	        scalar,  the bandwidth       
; Output                                                                     
; Parameter	b     
; Definition		M x 1 	vector of estimated slope coefficients                 
; ------------------------------------------------------------------------
;  Example 	
;		library("xplore")
;		library("metrics")
;		randomize(66666)
; 		n	= 200				; sample size
;		ss1	= #(1,0.9)~#(0.9,1)		; covariance matrix of error terms
;		g	= #(1)				; true coefficient of decision equation
;		b	= #(-9, 1)			; true intercept and slope of outcome equation
;		u	= gennorm(n, #(0,0), ss1)	; generate realizations of joint distribution of error terms
;		ss2     = #(1,0.4)~#(0.4,1)		; covariance matrix of regressors
;		xz      = gennorm(n, #(0,0), ss2)       ; generate realizations of joint distribution of regressors
;		z       = xz[,2]			; regressor of decision equation
;		q       = (z*g+u[,1].>=0)		; generate binary dependent variable of decision equation
;		hd	= 0.1*(max(z) - min(z))		; bandwidth for dwade procedure
;		d	= dwade(z,q,hd)*(2*sqrt(3)*pi)	; dwade estimate * scaling factor
;		id	= z*d				; estimated first-step index
;		h       = 0.2*(max(id) - min(id))	;  bandwidth for powell procedure
;		x	= matrix(n)~xz[,1]		; regressors for outcome equation
;		y       = x*b+u[,2]			; dependent variable for outcome equation
;		zz	= paf(y~x~id, q)		; impose censored sampling
;		y	= zz[,1]
;		x	= zz[,3:(cols(zz)-1)]
;		id	= zz[,cols(zz)]		
;		b	= powell(x,y,id,h)
;		b					; estimated slope coefficient
; -----------------------------------------------------------------
;   Result    estimated slope of the outcome equation of a semiparametric
;             sample selection model according to Ahn and Powel (1993)
;-------------------------------------------------------------------------
; Author	akw,961011 
; ----------------------------------------------------------------------------
		z=sort(id~y~x,1)
		n=rows(z)
		id=z[,1]
		z=z[,2:cols(z)]
		one=matrix(rows(id))
		num=sker(id, h,"qua",z~one)
		num=num-15/16.*(z~one)./(n*h)
		loo=num[,1:(cols(num)-1)]./(num[,cols(num)]+1e-10)
		yloo=z[,1]-loo[,1]
		xloo=z[,2:cols(z)]-loo[,2:cols(loo)]
		xins=z[,2:cols(z)].*(n*h.*(num[,cols(num)]+1e-10))
		b=inv(xins'*xloo)*(xins'*yloo)
	endp