proc(z)=prognos2(f,yh,zt,hh)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     prognose 
; -----------------------------------------------------------------
;   Macro        prognos2
; -----------------------------------------------------------------
;   Description  Forecasts of undifferenced series for VAR Models
; -----------------------------------------------------------------
;   Usage        z=prognos2(f,yh,zt,hh)  
;   Input
;     Parameter   f
;     Definition      matrix
;     Parameter   yh
;     Definition      matrix, forecasts of variables
;     Parameter   zt
;     Definition      vector, last observation of series 
;     Parameter   hh 
;     Definition    scalar, forecast horizon
;   Output
;     Parameter   z
;     Definition    matrix
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
  di=rows(yh)/hh
  z=zeros(di,1)
  yh=reshape(yh,di|hh)'
  cyh=cumsum(yh)+zt'
  h=1
  ef=eye(di)-f
  while (h<=hh)
    z=z~(f*cyh[h,]'+ef*yh[h,]')
    h=h+1
  endo
  z=vec(z[,2:cols(z)])
endp
