proc(yest2)=prognose(coeff,mw,ord,h,te,di,adj,typ,ytt)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      domulti
; -----------------------------------------------------------------
;   Macro         prognose
; -----------------------------------------------------------------
;   Description   forecasting in VAR models
; -----------------------------------------------------------------
;   Usage         yest2 = prognose(coeff,mw,ord,h,te,di,adj,typ,ytt)
;   Input
;     Parameter   coeff 
;     Definition    matrix, estimated coefficients
;     Parameter   mw 
;     Definition    matrix, mean of time series
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   h 
;     Definition    integer, forecast horizon
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   adj 
;     Definition    scalar, 1=if adjusted, 0=if not
;     Parameter   typ 
;     Definition    integer, the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;   Output
;     Parameter   yest2
;     Definition     matrix
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
if ((ord==0) && (adj==1))
   yest2=zeros(di*h,1)
else
   if (cols(coeff)==1)
     yest2=kron(ones(h,1),coeff)
   else
   nue=0
   if (adj==0)
      nue=coeff[,1]
      coeff=coeff[,2:cols(coeff)]
   endif
   vecy=vec(rev((ytt[,te-ord+1:te]-mw)')')
   i=1
   yest2=0
   while (i<=h)
      yest1=coeff*vecy+nue
      vecy=shiftr(vecy',di,0)'
      vecy[1:di,1]=yest1
      yest2=yest2 | yest1
      i=i+1
   endo
   yest2=yest2[2:rows(yest2),]
   endif
endif
endp
