proc (x) = randx (dist, n, shape)
; -----------------------------------------------------------------
;   Library       stats
; -----------------------------------------------------------------
;   See_also      pdfx cdfx qfx
; -----------------------------------------------------------------
;   Macro         randx
; -----------------------------------------------------------------
;   Description   randx generates a vector of pseudo random variables 
;                 with extreme value and generalized Pareto distribution.
; -----------------------------------------------------------------
;   Usage         r = randx (dist, n, shape)
;   Input
;     Parameter   dist
;     Definition      name of distribution
;     Parameter   n
;     Definition      integer, number of elements
;     Parameter   shape
;     Definition      shape parameter
;   Output
;     Parameter   r
;     Definition      vector
; -----------------------------------------------------------------
;   Example   library("stats")
;             randx("ev0", 3)
; -----------------------------------------------------------------
;   Result    [1,]  0.51199
;             [2,]  1.2308
;             [3,]  -0.98558
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------

if (exist (shape))
  x = qfx (dist, uniform (n), shape)
else 
  x = qfx (dist, uniform (n))
endif

endp
